/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import gregtech.GTMod;
import gregtech.common.GTClient;
import gregtech.common.render.GTRenderUtil;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import java.awt.Color;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RainbowOverlayRenderer
extends GeneratedMaterialRenderer {
    private float baseR = 1.0f;
    private float baseG = 1.0f;
    private float baseB = 1.0f;

    public RainbowOverlayRenderer(short[] rgba) {
        this.baseR = (float)rgba[0] / 255.0f;
        this.baseG = (float)rgba[1] / 255.0f;
        this.baseB = (float)rgba[2] / 255.0f;
    }

    @Override
    protected void renderRegularItem(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon icon, boolean shouldModulateColor) {
        GTClient clientProxy = GTMod.clientProxy();
        long animationTicks = clientProxy.getAnimationTicks();
        float partialTicks = clientProxy.getPartialRenderTicks();
        if (shouldModulateColor) {
            Color color = Color.getHSBColor(((float)(animationTicks % 180L) + partialTicks) % 90.0f / 90.0f, 0.4f, 0.9f);
            float modR = (float)color.getRed() / 255.0f;
            float modG = (float)color.getGreen() / 255.0f;
            float modB = (float)color.getBlue() / 255.0f;
            GL11.glColor3f((float)(this.baseR * modR), (float)(this.baseG * modG), (float)(this.baseB * modB));
        }
        GTRenderUtil.renderItem(type, icon);
    }
}

