/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRContext;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public abstract class SBRContextBase
implements ISBRContext {
    protected static final float[] LIGHTNESS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    @NotNull
    protected RenderBlocks renderBlocks = RenderBlocks.getInstance();
    @NotNull
    protected Block block = Blocks.field_150350_a;
    protected int x;
    protected int y;
    protected int z;
    protected int modelId;
    protected boolean hasLightnessOverride;
    protected float lightnessOverride;
    protected boolean hasBrightnessOverride;
    protected int brightnessOverride;
    protected boolean hasColorOverride;
    protected int colorOverride;

    private static int rgbaToInt(short @NotNull [] rgba) {
        return rgba[2] & 0xFF | (rgba[1] & 0xFF) << 8 | (rgba[0] & 0xFF) << 16;
    }

    public ISBRContext setup(@NotNull Block block, int modelId, @NotNull RenderBlocks renderBlocks) {
        this.block = block;
        this.modelId = modelId;
        this.renderBlocks = renderBlocks;
        return this;
    }

    @Override
    @NotNull
    public final RenderBlocks getRenderBlocks() {
        return this.renderBlocks;
    }

    @Override
    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @Override
    public final int getModelId() {
        return this.modelId;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final int getZ() {
        return this.z;
    }

    @Override
    public final ISBRContext setBrightnessOverride(int brightness) {
        this.hasBrightnessOverride = true;
        this.brightnessOverride = brightness;
        return this;
    }

    @Override
    public final ISBRContext setLightnessOverride(float lightness) {
        this.hasLightnessOverride = true;
        this.lightnessOverride = lightness;
        return this;
    }

    @Override
    public final ISBRContext setupColor(ForgeDirection side, short[] rgba) {
        return this.setupColor(side, SBRContextBase.rgbaToInt(rgba));
    }

    @Override
    public final ISBRContext setRenderBoundsFromBlock() {
        this.renderBlocks.func_147775_a(this.block);
        return this;
    }

    @Override
    public void renderNegativeYFacing(ITexture[] tex) {
        for (ITexture layer : tex) {
            if (layer == null) continue;
            layer.renderYNeg(this);
        }
    }

    @Override
    public void renderPositiveYFacing(ITexture[] tex) {
        for (ITexture layer : tex) {
            if (layer == null) continue;
            layer.renderYPos(this);
        }
    }

    @Override
    public void renderNegativeZFacing(ITexture[] tex) {
        for (ITexture layer : tex) {
            if (layer == null) continue;
            layer.renderZNeg(this);
        }
    }

    @Override
    public void renderPositiveZFacing(ITexture[] tex) {
        for (ITexture layer : tex) {
            if (layer == null) continue;
            layer.renderZPos(this);
        }
    }

    @Override
    public void renderNegativeXFacing(ITexture[] tex) {
        for (ITexture layer : tex) {
            if (layer == null) continue;
            layer.renderXNeg(this);
        }
    }

    @Override
    public void renderPositiveXFacing(ITexture[] tex) {
        for (ITexture layer : tex) {
            if (layer == null) continue;
            layer.renderXPos(this);
        }
    }
}

