/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.prupe.mcpatcher.ctm.CTMUtils;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IBlockContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRContext;
import gregtech.api.render.ISBRWorldContext;
import gregtech.common.render.GTTextureBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class GTCopiedBlockTextureRender
extends GTTextureBase
implements ITexture,
IBlockContainer {
    private final Block mBlock;
    private final byte mSide;
    private final int mMeta;

    protected GTCopiedBlockTextureRender(Block aBlock, int ordinalSide, int aMeta, short[] aRGBa) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GTCopiedBlockTextureRender");
        }
        this.mBlock = aBlock;
        this.mSide = (byte)ordinalSide;
        this.mMeta = aMeta;
    }

    private IIcon getIcon(int ordinalSide, ISBRContext ctx) {
        IIcon iIcon;
        IIcon icon = this.mSide == 6 ? this.mBlock.func_149691_a(ordinalSide, this.mMeta) : this.mBlock.func_149691_a((int)this.mSide, this.mMeta);
        if (!Mods.Angelica.isModLoaded()) {
            return icon;
        }
        if (ctx instanceof ISBRWorldContext) {
            ISBRWorldContext ctxW = (ISBRWorldContext)ctx;
            iIcon = CTMUtils.getBlockIcon((IIcon)icon, (Block)this.mBlock, (IBlockAccess)ctxW.getBlockAccess(), (int)ctxW.getX(), (int)ctxW.getY(), (int)ctxW.getZ(), (int)ordinalSide);
        } else {
            iIcon = CTMUtils.getBlockIcon((IIcon)icon, (Block)this.mBlock, (int)ordinalSide);
        }
        return iIcon;
    }

    @Override
    public void renderXPos(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        IIcon aIcon = this.getIcon(ForgeDirection.EAST.ordinal(), ctx);
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        renderBlocks.field_152631_f = true;
        this.startDrawingQuads(renderBlocks, 1.0f, 0.0f, 0.0f);
        ctx.reset().setupColor(ForgeDirection.EAST, 0xFFFFFF);
        renderBlocks.func_147764_f(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
        renderBlocks.field_152631_f = false;
    }

    @Override
    public void renderXNeg(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, -1.0f, 0.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.WEST.ordinal(), ctx);
        ctx.reset().setupColor(ForgeDirection.WEST, 0xFFFFFF);
        renderBlocks.func_147798_e(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderYPos(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.UP.ordinal(), ctx);
        ctx.reset().setupColor(ForgeDirection.UP, 0xFFFFFF);
        renderBlocks.func_147806_b(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderYNeg(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, -1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.DOWN.ordinal(), ctx);
        ctx.reset().setupColor(ForgeDirection.DOWN, 0xFFFFFF);
        renderBlocks.func_147768_a(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderZPos(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 0.0f, 1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.SOUTH.ordinal(), ctx);
        ctx.reset().setupColor(ForgeDirection.SOUTH, 0xFFFFFF);
        renderBlocks.func_147734_d(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderZNeg(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 0.0f, -1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.NORTH.ordinal(), ctx);
        renderBlocks.field_152631_f = true;
        ctx.reset().setupColor(ForgeDirection.NORTH, 0xFFFFFF);
        renderBlocks.func_147761_c(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
        renderBlocks.field_152631_f = false;
    }

    @Override
    public boolean isValidTexture() {
        return this.mBlock != null;
    }

    @Override
    public Block getBlock() {
        return this.mBlock;
    }

    @Override
    public int getMeta() {
        return this.mMeta;
    }
}

