/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.CoverItemMeter;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneTransmitterBase;
import gregtech.common.gui.mui1.cover.WirelessItemDetectorUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class CoverWirelessItemDetector
extends CoverAdvancedRedstoneTransmitterBase {
    private int slot = -1;
    private int threshold = 0;
    private boolean physical = true;

    public CoverWirelessItemDetector(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public int getSlot() {
        return this.slot;
    }

    public CoverWirelessItemDetector setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public CoverWirelessItemDetector setThresdhold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    public boolean isPhysical() {
        return this.physical;
    }

    public CoverWirelessItemDetector setPhysical(boolean physical) {
        this.physical = physical;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        super.readDataFromNbt(nbt);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.threshold = tag.func_74762_e("threshold");
        this.slot = tag.func_74762_e("slot");
        this.physical = tag.func_74764_b("physical") ? tag.func_74767_n("physical") : false;
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        super.readDataFromPacket(byteData);
        this.threshold = byteData.readInt();
        this.slot = byteData.readInt();
        this.physical = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74768_a("threshold", this.threshold);
        tag.func_74768_a("slot", this.slot);
        tag.func_74757_a("physical", this.physical);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeDataToByteBuf(byteBuf);
        byteBuf.writeInt(this.threshold);
        byteBuf.writeInt(this.slot);
        byteBuf.writeBoolean(this.physical);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        byte signal = CoverItemMeter.computeSignalBasedOnItems(coverable, this.invert, this.threshold, this.slot, this.coverSide.ordinal());
        CoverPosition key = CoverWirelessItemDetector.getCoverKey(coverable, this.coverSide);
        CoverWirelessItemDetector.setSignalAt(this.getUuid(), this.getFrequency(), key, signal);
        if (this.physical) {
            coverable.setOutputRedstoneSignal(this.coverSide, signal);
        } else {
            coverable.setOutputRedstoneSignal(this.coverSide, (byte)0);
        }
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new WirelessItemDetectorUIFactory(buildContext).createWindow();
    }
}

