/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.gui;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.modularui2.widget.CoverTickRateButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class CoverGui<T extends Cover> {
    protected final T cover;
    protected static final int WIDGET_MARGIN = 5;
    protected static final int ROW_PADDING = 3;
    protected static final int ROW_ELEMENT_PADDING = 2;

    public CoverGui(T cover) {
        this.cover = cover;
    }

    protected String getGuiId() {
        return "hogehoge";
    }

    public void addUIWidgets(PanelSyncManager syncManager, Flow column) {
    }

    public final ModularPanel createStandalonePanel(PanelSyncManager syncManager, UISettings uiSettings) {
        ModularPanel basePanel = this.createBasePanel("standalone.cover", syncManager, uiSettings);
        if (this.doesBindPlayerInventory()) {
            basePanel.bindPlayerInventory();
        }
        return basePanel;
    }

    public ModularPanel createBasePanel(String panelName, PanelSyncManager syncManager, UISettings uiSettings) {
        syncManager.addCloseListener(player -> {
            if (!NetworkUtils.isClient((EntityPlayer)player)) {
                ((Cover)this.cover).getTile().func_70296_d();
            }
        });
        ModularPanel panel = (ModularPanel)ModularPanel.defaultPanel((String)panelName, (int)this.getGUIWidth(), (int)this.getGUIHeight()).debugName(this.getGuiId());
        Flow widgetsColumn = (Flow)((Flow)((Flow)Flow.column().coverChildren()).crossAxisAlignment(Alignment.CrossAxis.START).marginLeft(5)).marginTop(5);
        panel.child((IWidget)widgetsColumn);
        this.addTitleToUI(widgetsColumn);
        this.addUIWidgets(syncManager, widgetsColumn);
        if (((Cover)this.cover).getMinimumTickRate() > 0 && ((Cover)this.cover).allowsTickRateAddition()) {
            panel.child((IWidget)((CoverTickRateButton)new CoverTickRateButton((Cover)this.cover, syncManager).right(4)).bottom(4));
        }
        return panel;
    }

    protected void addTitleToUI(Flow column) {
        ItemStack coverItem = GTUtility.intToStack(((Cover)this.cover).getCoverID());
        if (coverItem == null) {
            return;
        }
        column.child((IWidget)((Flow)((Flow)((Flow)Flow.row().coverChildren()).marginBottom(4)).child((IWidget)new ItemDrawable(coverItem).asWidget())).child((IWidget)((TextWidget)new TextWidget(coverItem.func_82833_r()).marginLeft(4)).widgetTheme("textTitle")));
    }

    protected Flow makeRowLayout() {
        return ((Flow)((Flow)Flow.column().coverChildren()).crossAxisAlignment(Alignment.CrossAxis.START).marginLeft(5)).childPadding(3);
    }

    protected Flow positionRow(Flow row) {
        return ((Flow)row.coverChildren()).childPadding(2);
    }

    protected Flow makeNamedColumn(IKey name) {
        return (Flow)((Flow)Flow.column().coverChildren()).crossAxisAlignment(Alignment.CrossAxis.START).child((IWidget)name.asWidget());
    }

    protected TextFieldWidget makeNumberField(int width) {
        return (TextFieldWidget)((TextFieldWidget)new TextFieldWidget().setFormatAsInteger(true).width(width)).height(12);
    }

    protected TextFieldWidget makeNumberField() {
        return this.makeNumberField(80);
    }

    protected int getGUIWidth() {
        return 176;
    }

    protected int getGUIHeight() {
        return 107;
    }

    protected boolean doesBindPlayerInventory() {
        return false;
    }
}

