/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.CoverRedstoneWirelessBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

public class CoverRedstoneTransmitterInternal
extends CoverRedstoneWirelessBase {
    public CoverRedstoneTransmitterInternal(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void onCoverRemoval() {
        GregTechAPI.sWirelessRedstone.remove(this.coverData);
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        GregTechAPI.sWirelessRedstone.put(this.coverData, coverable.getOutputRedstoneSignal(this.coverSide));
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagInt) {
            NBTTagInt nbtInt = (NBTTagInt)nbt;
            int data = nbtInt.func_150287_d();
            if (data != this.coverData) {
                GregTechAPI.sWirelessRedstone.remove(this.coverData);
            }
            this.coverData = nbtInt.func_150287_d();
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)nbt;
        if (tag.func_74764_b("frequency") && tag.func_74762_e("frequency") != this.coverData) {
            GregTechAPI.sWirelessRedstone.remove(this.coverData);
        }
        this.coverData = tag.func_74762_e("frequency");
    }
}

