/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.gui.mui1.cover.ArmUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverArm
extends CoverLegacyData {
    public final int mTickRate;
    public static final int EXPORT_MASK = 0x40000000;
    public static final int SLOT_ID_MASK = 16383;
    protected static final int SLOT_ID_MIN = 0;
    public static final int CONVERTED_BIT = Integer.MIN_VALUE;

    public CoverArm(CoverContext context, int aTickRate, ITexture coverTexture) {
        super(context, coverTexture);
        this.mTickRate = aTickRate;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        int toSlot;
        int fromSlot;
        TileEntity toTile;
        TileEntity fromTile;
        IMachineProgress machine;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null || coverable instanceof IMachineProgress && !(machine = (IMachineProgress)((Object)coverable)).isAllowedToWork() || !(coverable instanceof TileEntity)) {
            return;
        }
        TileEntity tileEntity = (TileEntity)coverable;
        if ((this.coverData & 0x40000000) > 0) {
            fromTile = tileEntity;
            toTile = coverable.getTileEntityAtSide(this.coverSide);
            fromSlot = this.coverData & 0x3FFF;
            toSlot = this.coverData >> 14 & 0x3FFF;
        } else {
            fromTile = coverable.getTileEntityAtSide(this.coverSide);
            toTile = tileEntity;
            fromSlot = this.coverData >> 14 & 0x3FFF;
            toSlot = this.coverData & 0x3FFF;
        }
        if (fromSlot > 0 && toSlot > 0) {
            if (fromTile instanceof IInventory) {
                IInventory fromInventory = (IInventory)fromTile;
                if (toTile instanceof IInventory) {
                    IInventory toInventory = (IInventory)toTile;
                    GTUtility.moveFromSlotToSlot(fromInventory, toInventory, fromSlot - 1, toSlot - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
                }
            }
        } else if (toSlot > 0) {
            ForgeDirection toSide = (this.coverData & 0x40000000) > 0 ? this.coverSide : this.coverSide.getOpposite();
            GTUtility.moveOneItemStackIntoSlot(fromTile, toTile, toSide, toSlot - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        } else if (fromSlot > 0) {
            ForgeDirection toSide = (this.coverData & 0x40000000) > 0 ? this.coverSide : this.coverSide.getOpposite();
            if (fromTile instanceof IInventory) {
                IInventory fromInventory = (IInventory)fromTile;
                GTUtility.moveFromSlotToSide(fromInventory, toTile, fromSlot - 1, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        } else {
            ForgeDirection toSide;
            ForgeDirection fromSide;
            if ((this.coverData & 0x40000000) > 0) {
                fromSide = this.coverSide;
                toSide = this.coverSide.getOpposite();
            } else {
                fromSide = this.coverSide.getOpposite();
                toSide = this.coverSide;
            }
            GTUtility.moveOneItemStack(fromTile, toTile, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        }
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = 0;
        step = GTUtility.getClickedFacingCoords(this.coverSide, aX, aY, aZ)[0] >= 0.5f ? (step += aPlayer.func_70093_af() ? 256 : 16) : (step -= aPlayer.func_70093_af() ? 256 : 16);
        int newCoverData = this.getNewVar(this.getVariable(), step);
        this.sendMessageToPlayer(aPlayer, newCoverData);
        this.coverData = newCoverData;
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = GTUtility.getClickedFacingCoords(this.coverSide, aX, aY, aZ)[0] >= 0.5f ? 1 : -1;
        int tCoverVariable = this.getNewVar(this.getVariable(), step);
        this.sendMessageToPlayer(aPlayer, tCoverVariable);
        this.coverData = tCoverVariable;
        return true;
    }

    private void sendMessageToPlayer(EntityPlayer aPlayer, int var) {
        if ((var & 0x40000000) != 0) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.out_slot") + ((var >> 14 & 0x3FFF) - 1));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.in_slot") + ((var & 0x3FFF) - 1));
        }
    }

    private int getNewVar(int var, int step) {
        int intSlot = var & 0x3FFF;
        int adjSlot = var >> 14 & 0x3FFF;
        if ((var & 0x40000000) == 0) {
            int x = intSlot + step;
            if (x > 16383) {
                return this.createVar(0, 16383, 0);
            }
            if (x < 1) {
                return this.createVar(-step - intSlot + 1, 0, 0x40000000);
            }
            return this.createVar(0, x, 0);
        }
        int x = adjSlot - step;
        if (x > 16383) {
            return this.createVar(16383, 0, 0x40000000);
        }
        if (x < 1) {
            return this.createVar(0, step - adjSlot + 1, 0);
        }
        return this.createVar(x, 0, 0x40000000);
    }

    private int createVar(int adjSlot, int intSlot, int export) {
        return Integer.MIN_VALUE | export | (adjSlot & 0x3FFF) << 14 | intSlot & 0x3FFF;
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid fluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid fluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int slot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int slot) {
        return true;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return this.mTickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ArmUIFactory(buildContext).createWindow();
    }
}

