/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.structure.IStructureChannels;
import gregtech.api.util.GTUtility;
import gregtech.api.util.StringUtils;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.api.util.tooltip.TooltipTier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class MultiblockTooltipBuilder {
    private static final String TAB = "   ";
    private static final String COLON = ": ";
    private static final String SEPARATOR = ", ";
    private static final String TT_machineType = StatCollector.func_74838_a((String)"GT5U.MBTT.MachineType");
    private static final String TT_StaticParallels = StatCollector.func_74838_a((String)"GT5U.MBTT.Parallel.Base");
    private static final String TT_StaticSpeed = StatCollector.func_74838_a((String)"GT5U.MBTT.Speed.Base");
    private static final String TT_StaticEuEff = StatCollector.func_74838_a((String)"GT5U.MBTT.EuDiscount.Base");
    private static final String TT_DynamicParallels = StatCollector.func_74838_a((String)"GT5U.MBTT.Parallel.Additional");
    private static final String TT_SingularParallel = StatCollector.func_74838_a((String)"GT5U.MBTT.Parallel.Singular");
    private static final String TT_DynamicSpeed = StatCollector.func_74838_a((String)"GT5U.MBTT.Speed.Additional");
    private static final String TT_DynamicEuEff = StatCollector.func_74838_a((String)"GT5U.MBTT.EuDiscount.Additional");
    private static final String TT_Steam_StaticSteamEff = StatCollector.func_74838_a((String)"GT5U.MBTT.SteamDiscount.Base");
    private static final String TT_dimensions = StatCollector.func_74838_a((String)"GT5U.MBTT.Dimensions");
    private static final String TT_hollow = StatCollector.func_74838_a((String)"GT5U.MBTT.Hollow");
    private static final String TT_structure = StatCollector.func_74838_a((String)"GT5U.MBTT.Structure");
    private static final String TT_controller = StatCollector.func_74838_a((String)"GT5U.MBTT.Controller");
    private static final String TT_minimum = StatCollector.func_74838_a((String)"GT5U.MBTT.Minimum");
    private static final String TT_tiered = StatCollector.func_74838_a((String)"GT5U.MBTT.Tiered");
    private static final String TT_maintenancehatch = StatCollector.func_74838_a((String)"GT5U.MBTT.MaintenanceHatch");
    private static final String TT_energyhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.EnergyHatch");
    private static final String TT_dynamohatch = StatCollector.func_74838_a((String)"GT5U.MBTT.DynamoHatch");
    private static final String TT_mufflerhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.MufflerHatch");
    private static final String TT_inputbus = StatCollector.func_74838_a((String)"GT5U.MBTT.InputBus");
    private static final String TT_inputhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.InputHatch");
    private static final String TT_outputbus = StatCollector.func_74838_a((String)"GT5U.MBTT.OutputBus");
    private static final String TT_outputhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.OutputHatch");
    private static final String TT_tectechhatch = StatCollector.func_74838_a((String)"GT5U.MBTT.TecTechHatch");
    private static final String TT_steaminputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamInputBus");
    private static final String TT_steamoutputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamOutputBus");
    private static final String TT_steamhatch = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamHatch");
    private static final String TT_causes = StatCollector.func_74838_a((String)"GT5U.MBTT.Causes");
    private static final String TT_produces = StatCollector.func_74838_a((String)"GT5U.MBTT.Produces");
    private static final String TT_pps = StatCollector.func_74838_a((String)"GT5U.MBTT.PPS");
    private static final String TT_hold = StatCollector.func_74838_a((String)"GT5U.MBTT.Hold");
    private static final String TT_todisplay = StatCollector.func_74838_a((String)"GT5U.MBTT.Display");
    private static final String TT_structurehint = StatCollector.func_74838_a((String)"GT5U.MBTT.StructureHint");
    private static final String TT_addedBy = StatCollector.func_74838_a((String)"GT5U.MBTT.Mod");
    private static final String TT_air = StatCollector.func_74838_a((String)"GT5U.MBTT.Air");
    private static final String TT_StructureComplex = StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.Complex");
    private static final String TT_SeeStructure1 = StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.SeeStructure1");
    private static final String TT_SeeStructure2 = StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.SeeStructure2");
    private static final String TT_PerfectOC = StatCollector.func_74838_a((String)"GT5U.MBTT.PerfectOC");
    private static final String[] TT_dots = (String[])IntStream.range(0, 16).mapToObj(i -> StatCollector.func_74838_a((String)("structurelib.blockhint." + i + ".name"))).toArray(String[]::new);
    private List<String> iLines = new LinkedList<String>();
    private List<String> sLines = new LinkedList<String>();
    private List<String> hLines = new LinkedList<String>();
    private SetMultimap<Integer, String> hBlocks = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    private String[] iArray;
    private String[] sArray;
    private String[] hArray;

    public MultiblockTooltipBuilder() {
        this.hBlocks.put((Object)13, (Object)TT_air);
    }

    public MultiblockTooltipBuilder addMachineType(String machine) {
        this.iLines.add(TT_machineType + COLON + EnumChatFormatting.YELLOW + machine + EnumChatFormatting.RESET);
        return this;
    }

    public MultiblockTooltipBuilder addInfo(String info) {
        this.iLines.add(info);
        return this;
    }

    public MultiblockTooltipBuilder addStaticParallelInfo(Integer parallels) {
        this.iLines.add(String.format(TT_StaticParallels, TooltipHelper.parallelText(parallels)));
        return this;
    }

    public MultiblockTooltipBuilder addDynamicParallelInfo(Integer parallels, TooltipTier tier) {
        this.iLines.add(String.format(parallels == 1 ? TT_SingularParallel : TT_DynamicParallels, TooltipHelper.parallelText(parallels), tier.getValue()));
        return this;
    }

    public MultiblockTooltipBuilder addVoltageParallelInfo(int parallels) {
        return this.addDynamicParallelInfo(parallels, TooltipTier.VOLTAGE);
    }

    public MultiblockTooltipBuilder addDynamicMultiplicativeParallelInfo(Integer factor, TooltipTier tier) {
        this.iLines.add(String.format(TT_DynamicParallels, TooltipHelper.parallelText(factor.toString() + "x"), tier.getValue()));
        return this;
    }

    public MultiblockTooltipBuilder addStaticSpeedInfo(float speed) {
        this.iLines.add(String.format(TT_StaticSpeed, TooltipHelper.speedText(speed)));
        return this;
    }

    public MultiblockTooltipBuilder addDynamicSpeedInfo(float speed, TooltipTier tier) {
        this.iLines.add(String.format(TT_DynamicSpeed, TooltipHelper.speedText("+" + TooltipHelper.percentageFormat.format(speed)), tier.getValue()));
        return this;
    }

    public MultiblockTooltipBuilder addStaticEuEffInfo(float euEff) {
        this.iLines.add(String.format(TT_StaticEuEff, TooltipHelper.effText(euEff)));
        return this;
    }

    public MultiblockTooltipBuilder addDynamicEuEffInfo(float euEff, TooltipTier tier) {
        this.iLines.add(String.format(TT_DynamicEuEff, TooltipHelper.effText("-" + TooltipHelper.percentageFormat.format(euEff)), tier.getValue()));
        return this;
    }

    public MultiblockTooltipBuilder addBulkMachineInfo(int parallels, float speed, float euEff) {
        return this.addVoltageParallelInfo(parallels).addStaticSpeedInfo(speed).addStaticEuEffInfo(euEff);
    }

    public MultiblockTooltipBuilder addStaticSteamEffInfo(float steamEff) {
        this.iLines.add(String.format(TT_Steam_StaticSteamEff, TooltipHelper.effText(TooltipHelper.percentageFormat.format(steamEff))));
        return this;
    }

    public MultiblockTooltipBuilder addSteamBulkMachineInfo(int parallels, float speed, float steamEff) {
        return this.addStaticParallelInfo(parallels).addStaticSpeedInfo(speed).addStaticSteamEffInfo(steamEff);
    }

    public MultiblockTooltipBuilder addInfoAll(String ... infoStrings) {
        this.iLines.addAll(Arrays.asList(infoStrings));
        return this;
    }

    public MultiblockTooltipBuilder addSeparator() {
        return this.addSeparator(EnumChatFormatting.GRAY, 41);
    }

    public MultiblockTooltipBuilder addSeparator(EnumChatFormatting color) {
        return this.addSeparator(color, 41);
    }

    public MultiblockTooltipBuilder addSeparator(EnumChatFormatting color, int length) {
        switch (GTMod.proxy.separatorStyle) {
            case 0: {
                this.iLines.add(" ");
                break;
            }
            case 1: {
                this.iLines.add(color + StringUtils.getRepetitionOf('-', length));
                break;
            }
            default: {
                this.iLines.add(color.toString() + EnumChatFormatting.STRIKETHROUGH + StringUtils.getRepetitionOf('-', length));
            }
        }
        return this;
    }

    public MultiblockTooltipBuilder addPollutionAmount(int pollution) {
        if (pollution == 0) {
            return this;
        }
        this.iLines.add("" + EnumChatFormatting.DARK_PURPLE + pollution + " " + EnumChatFormatting.GRAY + TT_pps);
        return this;
    }

    public MultiblockTooltipBuilder beginStructureBlock(int w, int h, int l, boolean hollow) {
        this.sLines.add(EnumChatFormatting.WHITE + TT_dimensions + COLON + EnumChatFormatting.GOLD + w + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + h + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + l + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.GOLD + "W" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "H" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "L" + EnumChatFormatting.GRAY + ") " + (hollow ? EnumChatFormatting.RED + TT_hollow : ""));
        this.sLines.add(EnumChatFormatting.WHITE + TT_structure + COLON);
        return this;
    }

    public MultiblockTooltipBuilder beginVariableStructureBlock(int wmin, int wmax, int hmin, int hmax, int lmin, int lmax, boolean hollow) {
        this.sLines.add(EnumChatFormatting.WHITE + TT_dimensions + COLON + EnumChatFormatting.GOLD + wmin + (wmin != wmax ? "-" + wmax : "") + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + hmin + (hmin != hmax ? "-" + hmax : "") + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + lmin + (lmin != lmax ? "-" + lmax : "") + EnumChatFormatting.GRAY + " (" + EnumChatFormatting.GOLD + "W" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "H" + EnumChatFormatting.GRAY + "x" + EnumChatFormatting.GOLD + "L" + EnumChatFormatting.GRAY + ") " + (hollow ? EnumChatFormatting.RED + TT_hollow : ""));
        this.sLines.add(EnumChatFormatting.WHITE + TT_structure + COLON);
        return this;
    }

    public MultiblockTooltipBuilder addController(String info) {
        this.sLines.add(TAB + EnumChatFormatting.WHITE + TT_controller + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addCasingInfoExactly(String casingName, int count, boolean isTiered) {
        return this.addCasingInfoExactlyColored(casingName, EnumChatFormatting.GRAY, count, EnumChatFormatting.GOLD, isTiered);
    }

    public MultiblockTooltipBuilder addCasingInfoExactlyColored(String casingName, EnumChatFormatting textColor, int count, EnumChatFormatting countColor, boolean isTiered) {
        this.sLines.add(countColor + TAB + count + "x " + EnumChatFormatting.RESET + textColor + casingName + (isTiered ? " " + TT_tiered : ""));
        return this;
    }

    public MultiblockTooltipBuilder addCasingInfoMin(String casingName, int minCount, boolean isTiered) {
        return this.addCasingInfoMinColored(casingName, EnumChatFormatting.GRAY, minCount, EnumChatFormatting.GOLD, isTiered);
    }

    public MultiblockTooltipBuilder addCasingInfoMinColored(String casingName, EnumChatFormatting textColor, int minCount, EnumChatFormatting countColor, boolean isTiered) {
        this.sLines.add(countColor + TAB + minCount + "x " + EnumChatFormatting.RESET + textColor + casingName + " " + TT_minimum + (isTiered ? " " + TT_tiered : ""));
        return this;
    }

    public MultiblockTooltipBuilder addCasingInfoRange(String casingName, int minCount, int maxCount, boolean isTiered) {
        return this.addCasingInfoRangeColored(casingName, EnumChatFormatting.GRAY, minCount, maxCount, EnumChatFormatting.GOLD, isTiered);
    }

    public MultiblockTooltipBuilder addCasingInfoRangeColored(String casingName, EnumChatFormatting textColor, int minCount, int maxCount, EnumChatFormatting countColor, boolean isTiered) {
        this.sLines.add(countColor + TAB + minCount + "x" + EnumChatFormatting.GRAY + " - " + countColor + maxCount + "x " + EnumChatFormatting.RESET + textColor + casingName + (isTiered ? " " + TT_tiered : ""));
        return this;
    }

    public MultiblockTooltipBuilder addOtherStructurePart(String name, String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + name + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addMaintenanceHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_maintenancehatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addMufflerHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_mufflerhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addEnergyHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_energyhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addDynamoHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_dynamohatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addInputBus(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputbus + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addSteamInputBus(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_steaminputbus + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addInputHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addOutputBus(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputbus + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addSteamOutputBus(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_steamoutputbus + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addOutputHatch(String info) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputhatch + COLON + EnumChatFormatting.GRAY + info);
        return this;
    }

    public MultiblockTooltipBuilder addOtherStructurePart(String localizedName, String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + localizedName + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)localizedName);
        }
        return this;
    }

    public MultiblockTooltipBuilder addMultiAmpHatchInfo() {
        this.iLines.add(EnumChatFormatting.GREEN + GTUtility.translate("GT5U.MBTT.TecTechMultiAmp", new Object[0]));
        return this;
    }

    public MultiblockTooltipBuilder addTecTechHatchInfo() {
        this.iLines.add(EnumChatFormatting.GREEN + TT_tectechhatch);
        return this;
    }

    public MultiblockTooltipBuilder addPerfectOCInfo() {
        this.iLines.add(EnumChatFormatting.AQUA + TT_PerfectOC);
        return this;
    }

    public MultiblockTooltipBuilder addMinGlassForLaser(int t) {
        this.iLines.add(GTValues.TIER_COLORS[t] + GTValues.VN[t] + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.MinGlassForLaser"));
        return this;
    }

    public MultiblockTooltipBuilder addGlassEnergyLimitInfo() {
        this.iLines.add(StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.GlassEnergyLimit"));
        return this;
    }

    public MultiblockTooltipBuilder addGlassEnergyLimitInfo(int t) {
        this.iLines.add(StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.GlassEnergyLimit") + SEPARATOR + GTValues.TIER_COLORS[t] + GTValues.VN[t] + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.GlassEnergyLimitTier"));
        return this;
    }

    public MultiblockTooltipBuilder addNoTierSkips() {
        this.iLines.add(StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.NoTierSkips"));
        return this;
    }

    public MultiblockTooltipBuilder addUnlimitedTierSkips() {
        this.iLines.add(StatCollector.func_74838_a((String)"GT5U.MBTT.Structure.UnlimitedTierSkips"));
        return this;
    }

    public MultiblockTooltipBuilder addMaxTierSkips(int n) {
        this.iLines.add(StatCollector.func_74837_a((String)"GT5U.MBTT.Structure.MaxTierSkips", (Object[])new Object[]{n}));
        return this;
    }

    public MultiblockTooltipBuilder addMaintenanceHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_maintenancehatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_maintenancehatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addMufflerHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_mufflerhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_mufflerhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addEnergyHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_energyhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_energyhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addDynamoHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_dynamohatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_dynamohatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addInputBus(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputbus + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_inputbus);
        }
        return this;
    }

    public MultiblockTooltipBuilder addSteamInputBus(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_steaminputbus + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_steaminputbus);
        }
        return this;
    }

    public MultiblockTooltipBuilder addInputHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_inputhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_inputhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addOutputBus(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputbus + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_outputbus);
        }
        return this;
    }

    public MultiblockTooltipBuilder addSteamOutputBus(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_steamoutputbus + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_steamoutputbus);
        }
        return this;
    }

    public MultiblockTooltipBuilder addOutputHatch(String info, int ... dots) {
        this.sLines.add(EnumChatFormatting.WHITE + TAB + TT_outputhatch + COLON + EnumChatFormatting.GRAY + info);
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)TT_outputhatch);
        }
        return this;
    }

    public MultiblockTooltipBuilder addStructureInfo(String info) {
        this.sLines.add(TAB + info);
        return this;
    }

    public MultiblockTooltipBuilder addStructureInfoSeparator(EnumChatFormatting color, int length, boolean useFinisherConfig) {
        if (useFinisherConfig) {
            switch (GTMod.proxy.tooltipFinisherStyle) {
                case 0: {
                    break;
                }
                case 1: {
                    this.sLines.add("    ");
                    break;
                }
                case 2: {
                    this.sLines.add(TAB + color + StringUtils.getRepetitionOf('-', length));
                    break;
                }
                default: {
                    this.sLines.add(TAB + color.toString() + EnumChatFormatting.STRIKETHROUGH + StringUtils.getRepetitionOf('-', length));
                    break;
                }
            }
        } else {
            switch (GTMod.proxy.separatorStyle) {
                case 0: {
                    this.sLines.add("    ");
                    break;
                }
                case 1: {
                    this.sLines.add(TAB + color + StringUtils.getRepetitionOf('-', length));
                    break;
                }
                default: {
                    this.sLines.add(TAB + color + EnumChatFormatting.STRIKETHROUGH + StringUtils.getRepetitionOf('-', length));
                }
            }
        }
        return this;
    }

    public MultiblockTooltipBuilder addStructureInfoSeparator() {
        return this.addStructureInfoSeparator(EnumChatFormatting.GRAY, 30, false);
    }

    @Deprecated
    public MultiblockTooltipBuilder addSubChannelUsage(String channel, String purpose) {
        this.sLines.add(TAB + StatCollector.func_74837_a((String)"GT5U.MBTT.subchannel", (Object[])new Object[]{channel, purpose}));
        return this;
    }

    public MultiblockTooltipBuilder addSubChannelUsage(IStructureChannels channel, String purpose) {
        this.sLines.add(TAB + StatCollector.func_74837_a((String)"GT5U.MBTT.subchannel", (Object[])new Object[]{channel.get(), purpose}));
        return this;
    }

    public MultiblockTooltipBuilder addSubChannelUsage(IStructureChannels channel) {
        this.sLines.add(TAB + StatCollector.func_74837_a((String)"GT5U.MBTT.subchannel", (Object[])new Object[]{channel.get(), channel.getDefaultTooltip()}));
        return this;
    }

    public MultiblockTooltipBuilder addStructureHint(String info) {
        this.hLines.add(StatCollector.func_74838_a((String)info));
        return this;
    }

    public MultiblockTooltipBuilder addStructureHint(String nameKey, int ... dots) {
        for (int dot : dots) {
            this.hBlocks.put((Object)dot, (Object)StatCollector.func_74838_a((String)nameKey));
        }
        return this;
    }

    public MultiblockTooltipBuilder pipe(Consumer<MultiblockTooltipBuilder> fn) {
        fn.accept(this);
        return this;
    }

    public MultiblockTooltipBuilder toolTipFinisher(String ... authors) {
        return this.toolTipFinisher(EnumChatFormatting.GRAY, 41, authors);
    }

    public MultiblockTooltipBuilder toolTipFinisher(EnumChatFormatting separatorColor, int separatorLength, String ... authors) {
        switch (GTMod.proxy.tooltipFinisherStyle) {
            case 0: {
                break;
            }
            case 1: {
                this.iLines.add(" ");
                break;
            }
            case 2: {
                this.iLines.add(separatorColor + StringUtils.getRepetitionOf('-', separatorLength));
                break;
            }
            default: {
                this.iLines.add(separatorColor.toString() + EnumChatFormatting.STRIKETHROUGH + StringUtils.getRepetitionOf('-', separatorLength));
            }
        }
        this.iLines.add(TT_hold + " " + EnumChatFormatting.BOLD + "[LSHIFT]" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " " + TT_todisplay);
        if (authors != null && authors.length > 0) {
            String authorTag = "Author: ";
            StringBuilder sb = new StringBuilder();
            sb.append(TT_addedBy);
            sb.append(COLON);
            for (int i = 0; i < authors.length; ++i) {
                String author = authors[i];
                if (author.startsWith("Author: ")) {
                    sb.append(author.substring("Author: ".length()));
                } else {
                    sb.append(author);
                }
                if (i == authors.length - 1) continue;
                sb.append(EnumChatFormatting.RESET);
                sb.append(EnumChatFormatting.GRAY);
                sb.append(" & ");
                sb.append(EnumChatFormatting.GREEN);
            }
            this.iLines.add(sb.toString());
        }
        this.hLines.add(TT_structurehint);
        this.addStructureInfoSeparator(EnumChatFormatting.GRAY, 30, true);
        this.sLines.add(EnumChatFormatting.WHITE + TT_StructureComplex);
        this.sLines.add(EnumChatFormatting.WHITE + TT_SeeStructure1 + EnumChatFormatting.BLUE + " Structure" + EnumChatFormatting.DARK_BLUE + "Lib " + EnumChatFormatting.RESET + EnumChatFormatting.WHITE + TT_SeeStructure2);
        this.iArray = this.iLines.toArray(new String[0]);
        this.sArray = this.sLines.toArray(new String[0]);
        this.hArray = (String[])Stream.concat(this.hLines.stream(), this.hBlocks.asMap().entrySet().stream().map(e -> TT_dots[(Integer)e.getKey() - 1] + COLON + String.join((CharSequence)SEPARATOR, (Iterable)e.getValue()))).toArray(String[]::new);
        this.iLines = null;
        this.sLines = null;
        this.hLines = null;
        this.hBlocks = null;
        return this;
    }

    public String[] getInformation() {
        return this.iArray;
    }

    public String[] getStructureInformation() {
        return this.sArray;
    }

    public String[] getStructureHint() {
        return this.hArray;
    }
}

