/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class GTChunkManager
implements ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private final Map<TileEntity, ForgeChunkManager.Ticket> registeredTickets = new HashMap<TileEntity, ForgeChunkManager.Ticket>();
    public static GTChunkManager instance = new GTChunkManager();

    public static void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)GTMod.GT, (ForgeChunkManager.LoadingCallback)instance);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList<ForgeChunkManager.Ticket> validTickets = new ArrayList<ForgeChunkManager.Ticket>();
        if (GTValues.alwaysReloadChunkloaders) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                TileEntity tile;
                int x = ticket.getModData().func_74762_e("OwnerX");
                int y = ticket.getModData().func_74762_e("OwnerY");
                int z = ticket.getModData().func_74762_e("OwnerZ");
                if (y <= 0 || !((tile = world.func_147438_o(x, y, z)) instanceof IGregTechTileEntity) || !((IGregTechTileEntity)tile).isAllowedToWork()) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
                if (this.registeredTickets.containsKey(tile)) continue;
                this.registeredTickets.put(tile, ticket);
                if (((IGregTechTileEntity)tile).getMetaTileEntity() instanceof IChunkLoader) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)((IChunkLoader)((Object)((IGregTechTileEntity)tile).getMetaTileEntity())).getActiveChunk());
                }
                validTickets.add(ticket);
            }
        }
        return validTickets;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return ArrayListMultimap.create();
    }

    public static boolean requestPlayerChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ, String player) {
        if (!GTValues.enableChunkloaders) {
            return false;
        }
        if (!GTValues.alwaysReloadChunkloaders && chunkXZ == null) {
            return false;
        }
        if (GTValues.debugChunkloaders && chunkXZ != null) {
            GTLog.out.println("GTChunkManager: Chunk request: (" + chunkXZ.field_77276_a + ", " + chunkXZ.field_77275_b + ")");
        }
        if (GTChunkManager.instance.registeredTickets.containsKey(owner)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)GTChunkManager.instance.registeredTickets.get(owner), (ChunkCoordIntPair)chunkXZ);
        } else {
            ForgeChunkManager.Ticket ticket = player.isEmpty() ? ForgeChunkManager.requestTicket((Object)GTMod.GT, (World)owner.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL) : ForgeChunkManager.requestPlayerTicket((Object)GTMod.GT, (String)player, (World)owner.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket == null) {
                if (GTValues.debugChunkloaders) {
                    GTLog.out.println("GTChunkManager: ForgeChunkManager.requestTicket failed");
                }
                return false;
            }
            if (GTValues.debugChunkloaders) {
                GTLog.out.println("GTChunkManager: ticket issued for machine at: (" + owner.field_145851_c + ", " + owner.field_145848_d + ", " + owner.field_145849_e + ")");
            }
            NBTTagCompound tag = ticket.getModData();
            tag.func_74768_a("OwnerX", owner.field_145851_c);
            tag.func_74768_a("OwnerY", owner.field_145848_d);
            tag.func_74768_a("OwnerZ", owner.field_145849_e);
            tag.func_74778_a("OwnerType", owner.getClass().getSimpleName());
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
            if (GTValues.alwaysReloadChunkloaders) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(owner.field_145851_c >> 4, owner.field_145849_e >> 4));
            }
            GTChunkManager.instance.registeredTickets.put(owner, ticket);
        }
        return true;
    }

    public static boolean requestChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        return GTChunkManager.requestPlayerChunkLoad(owner, chunkXZ, "");
    }

    public static void releaseChunk(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        if (!GTValues.enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GTChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (GTValues.debugChunkloaders) {
                GTLog.out.println("GTChunkManager: Chunk release: (" + chunkXZ.field_77276_a + ", " + chunkXZ.field_77275_b + ")");
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
        }
    }

    public static void releaseTicket(TileEntity owner) {
        if (!GTValues.enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GTChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (GTValues.debugChunkloaders) {
                GTLog.out.println("GTChunkManager: ticket released by machine at: (" + owner.field_145851_c + ", " + owner.field_145848_d + ", " + owner.field_145849_e + ")");
                for (ChunkCoordIntPair chunk : ticket.getChunkList()) {
                    GTLog.out.println("GTChunkManager: Chunk release: (" + chunk.field_77276_a + ", " + chunk.field_77275_b + ")");
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            GTChunkManager.instance.registeredTickets.remove(owner);
        }
    }

    public static void printTickets() {
        GTLog.out.println("GTChunkManager: Start forced chunks dump:");
        GTChunkManager.instance.registeredTickets.forEach((machine, ticket) -> {
            GTLog.out.print("GTChunkManager: Chunks forced by the machine at (" + machine.field_145851_c + ", " + machine.field_145848_d + ", " + machine.field_145849_e + ")");
            if (ticket.isPlayerTicket()) {
                GTLog.out.print(" Owner: " + ticket.getPlayerName());
            }
            GTLog.out.print(" :");
            for (ChunkCoordIntPair c : ticket.getChunkList()) {
                GTLog.out.print("(");
                GTLog.out.print(c.field_77276_a);
                GTLog.out.print(", ");
                GTLog.out.print(c.field_77275_b);
                GTLog.out.print("), ");
            }
        });
        GTLog.out.println("GTChunkManager: End forced chunks dump:");
    }
}

