/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.render.TextureFactory;
import gregtech.common.gui.modularui.widget.FluidLockWidget;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTEHatchVoid
extends MTEHatchOutput {
    public MTEHatchVoid(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, new String[]{"Voids fluids from Multiblocks", "Must be configured to work", "Mimics behavior of restricted hatches"}, 1);
    }

    public MTEHatchVoid(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.FLUID_VOID_SIGN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.FLUID_VOID_SIGN)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchVoid(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aindex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aindex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        return aFluid.amount;
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean isEmptyAndAcceptsAnyFluid() {
        return this.mMode == 0;
    }

    @Override
    public boolean canStoreFluid(@Nonnull FluidStack fluidStack) {
        if (this.isFluidLocked()) {
            if (this.lockedFluidName == null) {
                return false;
            }
            return this.lockedFluidName.equals(fluidStack.getFluid().getName());
        }
        return false;
    }

    @Override
    protected void onEmptyingContainerWhenEmpty() {
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new FluidLockWidget(this).setPos(58, 41))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.hatch_output.lockfluid.label")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(TextWidget.dynamicString(() -> {
            FluidStack fluidStack = FluidRegistry.getFluidStack((String)this.lockedFluidName, (int)1);
            return fluidStack != null ? fluidStack.getLocalizedName() : StatCollector.func_74838_a((String)"GT5U.machines.hatch_output.lockfluid.empty");
        }).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.CenterLeft).setMaxWidth(65).setPos(10, 30))).widget((Widget)new FakeSyncWidget.ByteSyncer(() -> this.mMode, val -> {
            this.mMode = val;
        }));
    }
}

