/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.CircuitGeneration;

import bartworks.common.loaders.ItemRegistry;
import bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class BWMetaItems {
    private static BW_GT_MetaGenCircuits NEW_CIRCUIT_PARTS;

    public static BW_GT_MetaGenCircuits getCircuitParts() {
        return NEW_CIRCUIT_PARTS;
    }

    public static void init() {
        NEW_CIRCUIT_PARTS = new BW_GT_MetaGenCircuits();
        NEW_CIRCUIT_PARTS.addItem(0, "Circuit Imprint", "", SubTag.NO_UNIFICATION, SubTag.NO_RECYCLING);
        NEW_CIRCUIT_PARTS.addItem(1, "Sliced Circuit", "", SubTag.NO_UNIFICATION, SubTag.NO_RECYCLING);
        NEW_CIRCUIT_PARTS.addItem(2, "Raw Imprint supporting Board", "A Raw Board needed for Circuit Imprints", new Object[0]);
        NEW_CIRCUIT_PARTS.addItem(3, "Imprint supporting Board", "A Board needed for Circuit Imprints", new Object[0]);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.MagnetoResonaticDust.get(OrePrefixes.dust, 1), WerkstoffLoader.ArInGaPhoBiBoTe.get(OrePrefixes.dust, 4)).itemOutputs(NEW_CIRCUIT_PARTS.getStack(2)).duration(300).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.formingPressRecipes);
        RecipeMaps.autoclaveRecipes.add(new GTRecipe(false, new ItemStack[]{NEW_CIRCUIT_PARTS.getStack(2)}, new ItemStack[]{NEW_CIRCUIT_PARTS.getStack(3)}, null, new int[]{7500}, new FluidStack[]{Materials.SolderingAlloy.getMolten(576L)}, null, 300, (int)TierEU.RECIPE_EV, -200));
    }

    public static class BW_GT_MetaGenCircuits
    extends BW_GT_MetaGen_Item_Hook {
        public BW_GT_MetaGenCircuits() {
            super("bwMetaGeneratedItem0");
        }

        public final ItemStack getStack(int meta) {
            return this.getStack(meta, 1);
        }

        public final ItemStack getStack(int meta, int stackSize) {
            return new ItemStack((Item)this, stackSize, meta);
        }

        public final ItemStack getStackWithNBT(NBTTagCompound tag, int meta, int stackSize) {
            ItemStack itemStack = this.getStack(meta, stackSize);
            itemStack.func_77982_d(tag);
            return itemStack;
        }

        @Override
        public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List<ItemStack> aList) {
            if (aCreativeTab == this.func_77640_w()) {
                for (NBTTagCompound tag : CircuitImprintLoader.recipeTagMap.keySet()) {
                    ItemStack stack = new ItemStack((Item)NEW_CIRCUIT_PARTS, 1, 0);
                    stack.func_77982_d(tag);
                    aList.add(stack);
                }
            }
            super.func_150895_a(var1, aCreativeTab, aList);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public final void func_94581_a(IIconRegister aIconRegister) {
            short i;
            for (i = 0; i < CircuitImprintLoader.reverseIDs; i = (short)(i + 1)) {
                if (!this.mEnabledItems.get(i)) continue;
                BWUtil.set2DCoordTo1DArray(i, 0, 2, aIconRegister.func_94245_a("gregtech:" + this.func_77658_a() + "/" + i), this.mIconList);
            }
            for (i = CircuitImprintLoader.reverseIDs; i < Short.MAX_VALUE; i = (short)(i + 1)) {
                if (!this.mEnabledItems.get(i)) continue;
                BWUtil.set2DCoordTo1DArray(i, 0, 2, Objects.requireNonNull((ItemList)CircuitImprintLoader.circuitIIconRefs.get((Object)i)).get(1L, new Object[0]).func_77954_c(), this.mIconList);
                BWUtil.set2DCoordTo1DArray(i, 1, 2, aIconRegister.func_94245_a("bartworks:WrapOverlay"), this.mIconList);
            }
        }

        @Override
        protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
            if (aStack.func_77978_p() != null) {
                String itemName;
                ItemStack tagStack = CircuitImprintLoader.getStackFromTag(aStack.func_77978_p());
                String string = itemName = tagStack != null ? GTLanguageManager.getTranslation(GTLanguageManager.getTranslateableItemStackName(tagStack)) : StatCollector.func_74838_a((String)"tooltip.bw.item.circuit.tagged");
                if (aStack.func_77960_j() == 0) {
                    aList.add(StatCollector.func_74837_a((String)"tooltip.bw.item.circuit.tagged.imprint", (Object[])new Object[]{itemName}));
                } else if (aStack.func_77960_j() == 1) {
                    aList.add(StatCollector.func_74837_a((String)"tooltip.bw.item.circuit.tagged.sliced", (Object[])new Object[]{itemName}));
                }
            } else if (aStack.func_77960_j() == 0) {
                aList.add(StatCollector.func_74838_a((String)"tooltip.bw.item.circuit.imprint"));
            } else if (aStack.func_77960_j() == 1) {
                aList.add(StatCollector.func_74838_a((String)"tooltip.bw.item.circuit.sliced"));
            }
            super.addAdditionalToolTips(aList, aStack, aPlayer);
        }
    }

    public static class BW_GT_MetaGen_Item_Hook
    extends MetaBaseItem {
        public static final HashSet<BW_GT_MetaGen_Item_Hook> sInstances = new HashSet();
        public final IIcon[] mIconList = new IIcon[65534];
        public final BitSet mEnabledItems = new BitSet(Short.MAX_VALUE);

        private BW_GT_MetaGen_Item_Hook(String aUnlocalized) {
            super(aUnlocalized);
            this.func_77637_a(new CreativeTabs("bw.MetaItems.0"){

                public Item func_78016_d() {
                    return ItemRegistry.TAB;
                }
            });
            this.func_77627_a(true);
            this.func_77656_e(0);
            sInstances.add(this);
        }

        @Override
        public Long[] getElectricStats(ItemStack itemStack) {
            return null;
        }

        @Override
        public Long[] getFluidContainerStats(ItemStack itemStack) {
            return null;
        }

        public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
            Object tRandomData;
            int var9;
            if (aToolTip == null) {
                aToolTip = "";
            }
            ItemStack rStack = new ItemStack((Item)this, 1, aID);
            GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".name", aEnglish);
            GTLanguageManager.addStringLocalization(this.func_77667_c(rStack) + ".tooltip", aToolTip);
            ArrayList<TCAspects.TC_AspectStack> tAspects = new ArrayList<TCAspects.TC_AspectStack>();
            this.mEnabledItems.set(aID);
            Object[] var7 = aRandomData;
            int var8 = aRandomData.length;
            for (var9 = 0; var9 < var8; ++var9) {
                tRandomData = var7[var9];
                if (!(tRandomData instanceof SubTag) || tRandomData != SubTag.NO_UNIFICATION) continue;
                GTOreDictUnificator.addToBlacklist(rStack);
            }
            var7 = aRandomData;
            var8 = aRandomData.length;
            for (var9 = 0; var9 < var8; ++var9) {
                tRandomData = var7[var9];
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(aID, (IItemBehaviour)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TCAspects.TC_AspectStack) {
                    ((TCAspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GTUtility.isStringValid(tRandomData)) {
                        GTOreDictUnificator.registerOre(tRandomData, rStack);
                        continue;
                    }
                    GTOreDictUnificator.addItemData(rStack, (ItemData)tRandomData);
                    continue;
                }
                if (!tUseOreDict) continue;
                GTOreDictUnificator.registerOre(tRandomData, rStack);
            }
            if (GregTechAPI.sThaumcraftCompat != null) {
                GregTechAPI.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List<ItemStack> aList) {
            int j = this.mEnabledItems.length();
            for (int i = 0; i < j; ++i) {
                if (!this.mEnabledItems.get(i)) continue;
                ItemStack tStack = new ItemStack((Item)this, 1, i);
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
        }

        @Override
        protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
            super.addAdditionalToolTips(aList, aStack, aPlayer);
        }

        @Override
        public String func_77667_c(ItemStack aStack) {
            return this.func_77658_a() + "." + aStack.func_77960_j();
        }

        @Override
        public IIcon func_77617_a(int i) {
            if (this.mEnabledItems.get(i)) {
                return (IIcon)BWUtil.get2DCoordFrom1DArray(i, 0, 2, this.mIconList);
            }
            return null;
        }

        public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
            return this.func_77617_a(stack.func_77960_j());
        }

        public IIcon getIcon(ItemStack stack, int pass) {
            return this.func_77617_a(stack.func_77960_j());
        }
    }
}

