/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.loaders;

import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.recipe.Sievert;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RadioHatchMaterialLoader {
    static List<RadioHatchMaterial> radioHatchMaterials = new ArrayList<RadioHatchMaterial>();

    public static void radioHatchMaterialAdder(ItemStack recipeInput, int recipeSievert, byte recipeMass) {
        radioHatchMaterials.add(new RadioHatchMaterial(recipeInput, recipeSievert, recipeMass));
    }

    public static void run() {
        RadioHatchMaterialLoader.addRadioHatchMaterials();
        RadioHatchMaterialLoader.loadRadioHatchNEI();
    }

    public static void addRadioHatchMaterials() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (werkstoff == null || !werkstoff.getStats().isRadioactive() || werkstoff == WerkstoffLoader.Tiberium) continue;
            int level = (int)werkstoff.getStats().getProtons();
            if (werkstoff.hasItemType(OrePrefixes.stick)) {
                RadioHatchMaterialLoader.radioHatchMaterialAdder(werkstoff.get(OrePrefixes.stick), level, (byte)1);
            }
            if (!werkstoff.hasItemType(OrePrefixes.stickLong)) continue;
            RadioHatchMaterialLoader.radioHatchMaterialAdder(werkstoff.get(OrePrefixes.stickLong), level, (byte)2);
        }
        for (Materials materials : Materials.getAll()) {
            boolean validProton;
            if (materials == null || materials.mElement == null || !(validProton = materials.getProtons() >= 83L && !materials.equals(Materials.Tritanium) && !materials.equals(Materials.Naquadah))) continue;
            int level = (int)materials.getProtons();
            if (GTOreDictUnificator.get(OrePrefixes.stick, materials, 1L) != null) {
                RadioHatchMaterialLoader.radioHatchMaterialAdder(GTOreDictUnificator.get(OrePrefixes.stick, materials, 1L), level, (byte)1);
            }
            if (GTOreDictUnificator.get(OrePrefixes.stickLong, materials, 1L) == null) continue;
            RadioHatchMaterialLoader.radioHatchMaterialAdder(GTOreDictUnificator.get(OrePrefixes.stickLong, materials, 1L), level, (byte)2);
        }
        Materials[] specialMaterial = new Materials[]{Materials.Naquadah, Materials.NaquadahEnriched, Materials.Naquadria};
        int[] nArray = new int[]{130, 140, 150};
        for (int i = 0; i < specialMaterial.length; ++i) {
            if (GTOreDictUnificator.get(OrePrefixes.stick, specialMaterial[i], 1L) != null) {
                RadioHatchMaterialLoader.radioHatchMaterialAdder(GTOreDictUnificator.get(OrePrefixes.stick, specialMaterial[i], 1L), nArray[i], (byte)2);
            }
            if (GTOreDictUnificator.get(OrePrefixes.stickLong, specialMaterial[i], 1L) == null) continue;
            RadioHatchMaterialLoader.radioHatchMaterialAdder(GTOreDictUnificator.get(OrePrefixes.stickLong, specialMaterial[i], 1L), nArray[i], (byte)2);
        }
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodThorium.get(1L, new Object[0]), (int)Materials.Thorium.getProtons(), (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodThorium2.get(1L, new Object[0]), (int)Materials.Thorium.getProtons(), (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodThorium4.get(1L, new Object[0]), (int)Materials.Thorium.getProtons(), (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadah.get(1L, new Object[0]), 140, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadah2.get(1L, new Object[0]), 140, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadah4.get(1L, new Object[0]), 140, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodMOX.get(1L, new Object[0]), (int)Materials.Plutonium.getProtons(), (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodMOX2.get(1L, new Object[0]), (int)Materials.Plutonium.getProtons(), (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodMOX4.get(1L, new Object[0]), (int)Materials.Plutonium.getProtons(), (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodUranium.get(1L, new Object[0]), (int)Materials.Uranium.getProtons(), (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodUranium2.get(1L, new Object[0]), (int)Materials.Uranium.getProtons(), (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodUranium4.get(1L, new Object[0]), (int)Materials.Uranium.getProtons(), (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodTiberium.get(1L, new Object[0]), (int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons(), (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodTiberium2.get(1L, new Object[0]), (int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons(), (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodTiberium4.get(1L, new Object[0]), (int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons(), (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodThorium.get(1L, new Object[0]), (int)Materials.Thorium.getProtons() / 10, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodThorium2.get(1L, new Object[0]), (int)Materials.Thorium.getProtons() / 10, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodThorium4.get(1L, new Object[0]), (int)Materials.Thorium.getProtons() / 10, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadah32.get(1L, new Object[0]), 140, (byte)96);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadah.get(1L, new Object[0]), 14, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadah2.get(1L, new Object[0]), 14, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadah4.get(1L, new Object[0]), 14, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodMOX.get(1L, new Object[0]), (int)Materials.Plutonium.getProtons() / 10, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodMOX2.get(1L, new Object[0]), (int)Materials.Plutonium.getProtons() / 10, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodMOX4.get(1L, new Object[0]), (int)Materials.Plutonium.getProtons() / 10, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodUranium.get(1L, new Object[0]), (int)Materials.Uranium.getProtons() / 10, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodUranium2.get(1L, new Object[0]), (int)Materials.Uranium.getProtons() / 10, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodUranium4.get(1L, new Object[0]), (int)Materials.Uranium.getProtons() / 10, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodTiberium.get(1L, new Object[0]), (int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodTiberium2.get(1L, new Object[0]), (int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodTiberium4.get(1L, new Object[0]), (int)WerkstoffLoader.Tiberium.getBridgeMaterial().getProtons() / 10, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadah32.get(1L, new Object[0]), 13, (byte)96);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadria.get(1L, new Object[0]), 150, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadria2.get(1L, new Object[0]), 150, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.RodNaquadria4.get(1L, new Object[0]), 150, (byte)12);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadria.get(1L, new Object[0]), 15, (byte)3);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadria2.get(1L, new Object[0]), 15, (byte)6);
        RadioHatchMaterialLoader.radioHatchMaterialAdder(ItemList.DepletedRodNaquadria4.get(1L, new Object[0]), 15, (byte)12);
    }

    public static void loadRadioHatchNEI() {
        for (RadioHatchMaterial recipes : radioHatchMaterials) {
            GTValues.RA.stdBuilder().itemInputs(recipes.getRecipeInput()).duration(0).eut(0).metadata(GTRecipeConstants.SIEVERT, new Sievert(recipes.recipeSievert)).metadata(GTRecipeConstants.MASS, Integer.valueOf(recipes.recipeMass)).fake().addTo(BartWorksRecipeMaps.radioHatchFakeRecipes);
        }
    }

    public static RadioHatchMaterial getRadioHatchMaterialFromInput(RadioHatchMaterial recipe, ItemStack Material2) {
        if (recipe.getRecipeInput().func_77969_a(Material2)) {
            return recipe;
        }
        return null;
    }

    public static List<RadioHatchMaterial> getRadioHatchMaterialList() {
        return radioHatchMaterials;
    }

    public static class RadioHatchMaterial {
        private final ItemStack recipeInput;
        public final int recipeSievert;
        public final byte recipeMass;

        public RadioHatchMaterial(ItemStack recipeInput, int recipeSievert, byte recipeMass) {
            this.recipeInput = recipeInput;
            this.recipeSievert = recipeSievert;
            this.recipeMass = recipeMass;
        }

        public ItemStack getRecipeInput() {
            return this.recipeInput.func_77946_l();
        }
    }
}

