/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.minigame.minesweeper.Mark;
import ru.timeconqueror.lootgames.minigame.minesweeper.Type;
import ru.timeconqueror.lootgames.utils.future.ICodec;
import ru.timeconqueror.timecore.api.util.CodecUtils;
import ru.timeconqueror.timecore.api.util.Wrapper;

public class MSBoard {
    int cFlaggedFields;
    private MSField[][] board;
    private int size;
    private int bombCount;

    public MSBoard(int size, int bombCount) {
        this.size = size;
        this.bombCount = bombCount;
    }

    void updateFlaggedFields_c() {
        this.cFlaggedFields = 0;
        MSField[][] mSFieldArray = this.board;
        int n = mSFieldArray.length;
        for (int i = 0; i < n; ++i) {
            MSField[] msFields;
            for (MSField msField : msFields = mSFieldArray[i]) {
                if (msField.mark != Mark.FLAG) continue;
                ++this.cFlaggedFields;
            }
        }
    }

    public boolean isGenerated() {
        return this.board != null;
    }

    void reveal(Pos2i pos) {
        this.getField(pos).reveal();
    }

    void reveal(int x, int y) {
        this.getField(x, y).reveal();
    }

    public boolean isHidden(Pos2i pos) {
        return this.getField(pos).isHidden;
    }

    public boolean isHidden(int x, int y) {
        return this.getField(x, y).isHidden;
    }

    public Type getType(Pos2i pos) {
        return this.getField(pos).type;
    }

    public Type getType(int x, int y) {
        return this.getField(x, y).type;
    }

    void swapMark(Pos2i pos) {
        this.getField(pos).swapMark();
    }

    public Mark getMark(Pos2i pos) {
        return this.getField(pos).mark;
    }

    public Mark getMark(int x, int y) {
        return this.getField(x, y).mark;
    }

    void resetBoard() {
        this.resetBoard(this.size, this.bombCount);
    }

    void resetBoard(int newBoardSize, int newBombCount) {
        this.size = newBoardSize;
        this.bombCount = newBombCount;
        this.board = null;
    }

    boolean isBomb(int x, int y) {
        return this.getType(x, y) == Type.BOMB;
    }

    boolean isBomb(Pos2i pos) {
        return this.getType(pos) == Type.BOMB;
    }

    public boolean hasFieldOn(Pos2i pos) {
        return pos.getX() >= 0 && pos.getY() >= 0 && pos.getX() < this.size && pos.getY() < this.size;
    }

    boolean checkWin() {
        boolean winState = true;
        MSField[][] mSFieldArray = this.board;
        int n = mSFieldArray.length;
        block0: for (int i = 0; i < n; ++i) {
            MSField[] msFields;
            for (MSField msField : msFields = mSFieldArray[i]) {
                if (msField.type == Type.BOMB) {
                    if (msField.isHidden && msField.mark == Mark.FLAG) continue;
                    winState = false;
                    break block0;
                }
                if (!msField.isHidden) continue;
                winState = false;
                break block0;
            }
        }
        return winState;
    }

    public MSField getField(Pos2i pos) {
        return this.board[pos.getX()][pos.getY()];
    }

    private MSField getField(int x, int y) {
        return this.board[x][y];
    }

    private List<Integer> getAvailableBombIndices(Pos2i start, int fieldSize) {
        int emptyPlaces = this.size * this.size - this.bombCount;
        if (emptyPlaces < 0) {
            throw new IllegalStateException("How is that possible, that board square is less or equal to bomb count? Square = " + this.size * this.size + ", bomb count = " + this.bombCount);
        }
        int safeDistance = emptyPlaces >= 13 ? 2 : (emptyPlaces >= 9 ? 1 : 0);
        Wrapper<Integer> count = new Wrapper<Integer>(0);
        return IntStream.range(0, fieldSize).filter(index -> {
            if ((Integer)count.get() > emptyPlaces) {
                return true;
            }
            Pos2i pos = this.toPos(index);
            if (start.manhattanDistanceTo(pos) <= safeDistance) {
                count.set((Integer)count.get() + 1);
                return false;
            }
            return true;
        }).boxed().collect(Collectors.toList());
    }

    public void generate(Pos2i startFieldPos) {
        if (this.toIndex(startFieldPos) > this.size * this.size - 1) {
            throw new IllegalArgumentException(String.format("Start Pos must be strictly less than Board size. Current values: start pos = %1$s, boardSize = %2$d", startFieldPos, this.size));
        }
        this.board = new MSField[this.size][this.size];
        int square = this.size * this.size;
        List<Integer> fields = this.getAvailableBombIndices(startFieldPos, square);
        Collections.shuffle(fields);
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                this.board[i][j] = new MSField(null, true, Mark.NO_MARK);
            }
        }
        for (Integer integer : fields.subList(0, this.bombCount)) {
            this.board[integer % this.size][integer / this.size].type = Type.BOMB;
        }
        for (int i = 0; i < this.board.length; ++i) {
            for (int j = 0; j < this.board[i].length; ++j) {
                if (this.isBomb(i, j)) continue;
                this.board[i][j].type = Type.byId((byte)this.getConnectedBombCount(i, j));
            }
        }
    }

    public Pos2i toPos(int fieldIndex) {
        return new Pos2i(fieldIndex % this.size, fieldIndex / this.size);
    }

    public int toIndex(Pos2i pos) {
        return pos.getY() * this.size + pos.getX();
    }

    private int getConnectedBombCount(int x, int y) {
        int bombCount = 0;
        for (int i = -1; i <= 1; ++i) {
            int xCoord = x + i;
            if (xCoord < 0 || xCoord >= this.size()) continue;
            for (int j = -1; j <= 1; ++j) {
                int yCoord = y + j;
                if (yCoord < 0 || yCoord >= this.size() || !this.isBomb(xCoord, yCoord)) continue;
                ++bombCount;
            }
        }
        return bombCount;
    }

    public void forEach(Consumer<Pos2i> func) {
        for (int x = 0; x < this.board.length; ++x) {
            for (int y = 0; y < this.board[x].length; ++y) {
                func.accept(new Pos2i(x, y));
            }
        }
    }

    public void forEach(BiConsumer<Integer, Integer> func) {
        for (int x = 0; x < this.board.length; ++x) {
            for (int y = 0; y < this.board[x].length; ++y) {
                func.accept(x, y);
            }
        }
    }

    public void cSetField(Pos2i pos, MSField field) {
        MSField oldField = this.board[pos.getX()][pos.getY()];
        Mark oldMark = oldField.mark;
        if (!field.isHidden) {
            field.mark = Mark.NO_MARK;
        }
        this.board[pos.getX()][pos.getY()] = field;
        if (oldMark == Mark.FLAG && field.mark != Mark.FLAG) {
            --this.cFlaggedFields;
        } else if (oldMark != Mark.FLAG && field.mark == Mark.FLAG) {
            ++this.cFlaggedFields;
        }
    }

    private void setBoard(MSField[][] board) {
        this.board = board;
    }

    public int size() {
        return this.size;
    }

    public int getBombCount() {
        return this.bombCount;
    }

    void setBombCount(int bombCount) {
        this.bombCount = bombCount;
    }

    public int cGetFlaggedField() {
        return this.cFlaggedFields;
    }

    public void cSetFlaggedFields(int cFlaggedFields) {
        this.cFlaggedFields = cFlaggedFields;
    }

    void setSize(int size) {
        this.size = size;
    }

    NBTTagCompound writeNBTForSaving() {
        return CodecUtils.write2DimArr(this.board, MSField.SAVE_CODEC);
    }

    NBTTagCompound writeNBTForClient() {
        return CodecUtils.write2DimArr(this.board, MSField.SYNC_CODEC);
    }

    void readNBTFromClient(NBTTagCompound boardTag) {
        this.setBoard(CodecUtils.read2DimArr(boardTag, MSField.class, MSField.SYNC_CODEC));
        this.updateFlaggedFields_c();
    }

    void readNBTFromSave(NBTTagCompound boardTag) {
        this.setBoard(CodecUtils.read2DimArr(boardTag, MSField.class, MSField.SAVE_CODEC));
    }

    public static class MSField {
        private Type type;
        private Mark mark;
        private boolean isHidden;
        public static final Codec SYNC_CODEC = new Codec(true);
        public static final Codec SAVE_CODEC = new Codec(false);

        MSField(Type type, boolean isHidden, Mark mark) {
            this.type = type;
            this.isHidden = isHidden;
            this.mark = mark;
        }

        private void swapMark() {
            this.mark = this.mark.getNext();
        }

        private void resetMark() {
            this.mark = Mark.NO_MARK;
        }

        private void reveal() {
            this.isHidden = false;
            this.resetMark();
        }

        public Type getType() {
            return this.type;
        }

        public Mark getMark() {
            return this.mark;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public String toString() {
            return "Field{type: " + (Object)((Object)this.type) + ", hidden: " + this.isHidden + ", mark: " + (Object)((Object)this.mark) + "}";
        }

        public static class Codec
        implements ICodec<MSField, NBTTagCompound> {
            private final boolean forSync;

            public Codec(boolean forSync) {
                this.forSync = forSync;
            }

            @Override
            public NBTTagCompound encode(MSField field) {
                NBTTagCompound compound = new NBTTagCompound();
                if (!this.forSync || !field.isHidden()) {
                    compound.func_74782_a("type", (NBTBase)Type.CODEC.encode(field.getType()));
                }
                compound.func_74757_a("hidden", field.isHidden());
                compound.func_74782_a("mark", (NBTBase)Mark.CODEC.encode(field.getMark()));
                return compound;
            }

            @Override
            public MSField decode(NBTTagCompound nbt) {
                return new MSField(this.forSync && !nbt.func_74764_b("type") ? Type.EMPTY : Type.CODEC.decode((NBTTagByte)nbt.func_74781_a("type")), nbt.func_74767_n("hidden"), Mark.CODEC.decode((NBTTagByte)nbt.func_74781_a("mark")));
            }
        }
    }
}

