/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.utils;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.North;
import com.jamesswafford.chess4j.board.squares.South;
import com.jamesswafford.chess4j.board.squares.Square;

public class PawnUtils {
    private static long[] isolated = new long[64];
    private static long[][] passed = new long[64][2];

    public static boolean isPassedPawn(Board board, Square pawnSq, boolean isWhite) {
        long enemies = isWhite ? board.getBlackPawns() : board.getWhitePawns();
        return (passed[pawnSq.value()][isWhite ? Color.WHITE.ordinal() : Color.BLACK.ordinal()] & enemies) == 0L;
    }

    public static boolean isDoubled(Board board, Square pawnSq, boolean isWhite) {
        long fileMask = Bitboard.files[pawnSq.file().getValue()] ^ Bitboard.squares[pawnSq.value()];
        if (isWhite) {
            return (fileMask & board.getWhitePawns()) != 0L;
        }
        return (fileMask & board.getBlackPawns()) != 0L;
    }

    public static boolean isIsolated(Board board, Square pawnSq, boolean isWhite) {
        long friends = isWhite ? board.getWhitePawns() : board.getBlackPawns();
        return (isolated[pawnSq.value()] & friends) == 0L;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            PawnUtils.isolated[i] = 0L;
            Square sq = Square.valueOf(i);
            if (sq.file().getValue() > File.FILE_A.getValue()) {
                int n = i;
                isolated[n] = isolated[n] | Bitboard.files[sq.file().getValue() - 1];
            }
            if (sq.file().getValue() < File.FILE_H.getValue()) {
                int n = i;
                isolated[n] = isolated[n] | Bitboard.files[sq.file().getValue() + 1];
            }
            PawnUtils.passed[i][Color.WHITE.ordinal()] = Bitboard.rays[i][North.getInstance().value()];
            PawnUtils.passed[i][Color.BLACK.ordinal()] = Bitboard.rays[i][South.getInstance().value()];
            if (sq.file().getValue() > File.FILE_A.getValue()) {
                long[] lArray = passed[i];
                int n = Color.WHITE.ordinal();
                lArray[n] = lArray[n] | Bitboard.rays[i - 1][North.getInstance().value()];
                long[] lArray2 = passed[i];
                int n2 = Color.BLACK.ordinal();
                lArray2[n2] = lArray2[n2] | Bitboard.rays[i - 1][South.getInstance().value()];
            }
            if (sq.file().getValue() >= File.FILE_H.getValue()) continue;
            long[] lArray = passed[i];
            int n = Color.WHITE.ordinal();
            lArray[n] = lArray[n] | Bitboard.rays[i + 1][North.getInstance().value()];
            long[] lArray3 = passed[i];
            int n3 = Color.BLACK.ordinal();
            lArray3[n3] = lArray3[n3] | Bitboard.rays[i + 1][South.getInstance().value()];
        }
    }
}

