/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board.squares;

import com.jamesswafford.chess4j.board.squares.East;
import com.jamesswafford.chess4j.board.squares.North;
import com.jamesswafford.chess4j.board.squares.NorthEast;
import com.jamesswafford.chess4j.board.squares.NorthWest;
import com.jamesswafford.chess4j.board.squares.South;
import com.jamesswafford.chess4j.board.squares.SouthEast;
import com.jamesswafford.chess4j.board.squares.SouthWest;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.board.squares.West;

public abstract class Direction {
    public static Direction[][] directionTo = new Direction[64][64];

    private static Direction directionTo(Square from, Square to) {
        int fDiff = from.file().getValue() - to.file().getValue();
        int rDiff = from.rank().getValue() - to.rank().getValue();
        if (fDiff == 0) {
            if (rDiff < 0) {
                return South.getInstance();
            }
            if (rDiff > 0) {
                return North.getInstance();
            }
        } else if (fDiff < 0) {
            if (rDiff == 0) {
                return East.getInstance();
            }
            if (rDiff == fDiff) {
                return SouthEast.getInstance();
            }
            if (rDiff == -fDiff) {
                return NorthEast.getInstance();
            }
        } else {
            if (rDiff == 0) {
                return West.getInstance();
            }
            if (rDiff == fDiff) {
                return NorthWest.getInstance();
            }
            if (rDiff == -fDiff) {
                return SouthWest.getInstance();
            }
        }
        return null;
    }

    public abstract Square next(Square var1);

    public abstract boolean isDiagonal();

    public abstract int value();

    static {
        for (int i = 0; i < 64; ++i) {
            Square sq = Square.valueOf(i);
            for (int j = 0; j < 64; ++j) {
                Square sq2 = Square.valueOf(j);
                Direction.directionTo[i][j] = Direction.directionTo(sq, sq2);
            }
        }
    }
}

