/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.TipList;
import mcp.mobius.waila.cbcore.Layout;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class WailaTickHandler {
    private Tooltip tooltip = null;
    private final MetaDataProvider handler = new MetaDataProvider();

    @SubscribeEvent
    public void tickRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayRenderer.renderOverlay(this.tooltip);
        }
    }

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityClientPlayerMP player = mc.field_71439_g;
        if (world == null || player == null) {
            this.tooltip = null;
            RayTracing.instance().clear();
            return;
        }
        RayTracing.instance().fire();
        MovingObjectPosition target = RayTracing.instance().getTarget();
        if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            DataAccessorCommon accessor = DataAccessorCommon.instance;
            accessor.set((World)world, (EntityPlayer)player, target);
            ItemStack targetStack = RayTracing.instance().getTargetStack();
            if (targetStack != null) {
                TipList currenttip = new TipList();
                List<Object> currenttipHead = new TipList();
                List<Object> currenttipBody = new TipList();
                List<Object> currenttipTail = new TipList();
                currenttipHead = this.handler.handleBlockTextData(targetStack, (World)world, (EntityPlayer)player, target, accessor, currenttipHead, Layout.HEADER);
                currenttipBody = this.handler.handleBlockTextData(targetStack, (World)world, (EntityPlayer)player, target, accessor, currenttipBody, Layout.BODY);
                currenttipTail = this.handler.handleBlockTextData(targetStack, (World)world, (EntityPlayer)player, target, accessor, currenttipTail, Layout.FOOTER);
                if (ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_SHIFTBLOCK, false) && !currenttipBody.isEmpty() && !accessor.getPlayer().func_70093_af()) {
                    currenttipBody.clear();
                    currenttipBody.add(SpecialChars.ITALIC + "Press shift for more data");
                }
                currenttip.addAll(currenttipHead);
                currenttip.addAll(currenttipBody);
                currenttip.addAll(currenttipTail);
                this.tooltip = new Tooltip(currenttip, targetStack);
            }
        } else if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            DataAccessorCommon accessor = DataAccessorCommon.instance;
            accessor.set((World)world, (EntityPlayer)player, target);
            Entity targetEnt = RayTracing.instance().getTargetEntity();
            if (targetEnt != null) {
                TipList currenttip = new TipList();
                List<Object> currenttipHead = new TipList();
                List<Object> currenttipBody = new TipList();
                List<Object> currenttipTail = new TipList();
                currenttipHead = this.handler.handleEntityTextData(targetEnt, (World)world, (EntityPlayer)player, target, accessor, currenttipHead, Layout.HEADER);
                currenttipBody = this.handler.handleEntityTextData(targetEnt, (World)world, (EntityPlayer)player, target, accessor, currenttipBody, Layout.BODY);
                currenttipTail = this.handler.handleEntityTextData(targetEnt, (World)world, (EntityPlayer)player, target, accessor, currenttipTail, Layout.FOOTER);
                if (ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_SHIFTENTS, false) && !currenttipBody.isEmpty() && !accessor.getPlayer().func_70093_af()) {
                    currenttipBody.clear();
                    currenttipBody.add(SpecialChars.ITALIC + "Press shift for more data");
                }
                currenttip.addAll(currenttipHead);
                currenttip.addAll(currenttipBody);
                currenttip.addAll(currenttipTail);
                this.tooltip = new Tooltip(currenttip, false);
            }
        }
    }
}

