/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.recipe;

import com.google.common.cache.CacheLoader;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import org.embeddedt.archaicfix.ducks.IAcceleratedRecipe;

public class RecipeCacheLoader
extends CacheLoader<Set<Item>, IRecipe[]> {
    private static final IRecipe[] NO_RECIPES = new IRecipe[0];

    public IRecipe[] load(Set<Item> key) throws Exception {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        if (key.size() == 0) {
            return NO_RECIPES;
        }
        return (IRecipe[])recipes.parallelStream().filter(recipe -> {
            if (!(recipe instanceof IAcceleratedRecipe)) {
                return true;
            }
            Set<Item> potentialItems = ((IAcceleratedRecipe)recipe).getPotentialItems();
            if (potentialItems == null) {
                return true;
            }
            for (Item item : key) {
                if (potentialItems.contains(item)) continue;
                return false;
            }
            return true;
        }).toArray(IRecipe[]::new);
    }
}

