/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.asm;

import com.gtnewhorizon.gtnhmixins.builders.IBaseTransformer;
import com.gtnewhorizon.gtnhmixins.builders.IMixins;
import com.gtnewhorizon.gtnhmixins.builders.ITargetMod;
import com.gtnewhorizon.gtnhmixins.builders.MixinBuilder;
import javax.annotation.Nonnull;
import org.embeddedt.archaicfix.asm.TargetedMod;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.helpers.DragonAPIHelper;

public enum Mixin implements IMixins
{
    MINECRAFT(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).addCommonMixins(new String[]{"core.AccessorEntityLiving", "core.MixinEntityPlayerMP", "core.MixinWorldServer", "core.MixinMapGenStructure", "core.MixinEntityVillager", "core.MixinMerchantRecipe", "core.MixinAxisAlignedBB", "core.MixinMaterialLiquid", "core.MixinChunkProviderServer", "core.MixinChunkIOProvider", "core.MixinSpawnerAnimals", "core.MixinShapedOreRecipe", "core.MixinLongHashMap", "core.MixinBlock", "core.MixinBlock_Late", "core.MixinEnchantmentHelper", "core.MixinWorldChunkManager", "core.MixinShapedRecipes", "core.MixinShapelessOreRecipe", "core.MixinShapelessRecipes", "core.MixinEntityLiving", "core.MixinWorld", "core.MixinEntityTrackerEntry", "core.MixinEntityXPOrb", "core.MixinEntity", "core.MixinForgeChunkManager", "core.MixinChunk", "core.MixinStructureStart", "core.MixinOreDictionary", "core.MixinChunkProviderHell", "core.MixinASMData", "core.MixinNetHandlerPlayServer"}).addClientMixins(new String[]{"core.MixinThreadDownloadImageData", "core.MixinBlockFence", "core.MixinEntityRenderer", "core.MixinGuiBeaconButton", "core.MixinGuiButton", "core.MixinGuiContainerCreative", "core.MixinIntegratedServer", "core.MixinChunkProviderClient", "core.MixinMinecraft", "core.MixinNetHandlerPlayClient", "core.MixinGuiCreateWorld", "core.MixinGuiIngameForge", "core.MixinFMLClientHandler", "core.MixinSplashProgress", "core.AccessorSplashProgress"})),
    RECIPE_CACHING(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.cacheRecipes).addCommonMixins(new String[]{"core.MixinCraftingManager"})),
    PHOSPHOR(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.enablePhosphor).addCommonMixins(new String[]{"lighting.MixinAnvilChunkLoader", "lighting.MixinChunk", "lighting.MixinChunkProviderServer", "lighting.MixinChunkVanilla", "lighting.MixinExtendedBlockStorage", "lighting.MixinSPacketChunkData", "lighting.MixinWorld_Lighting"}).addClientMixins(new String[]{"lighting.MixinMinecraft", "lighting.MixinWorld", "lighting.MixinChunkCache"})),
    PHOSPHOR_FASTCRAFT(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.enablePhosphor).addRequiredMod((ITargetMod)TargetedMod.FASTCRAFT).addCommonMixins(new String[]{"lighting.fastcraft.MixinChunk", "lighting.fastcraft.MixinChunkProviderServer", "lighting.fastcraft.MixinWorld"})),
    GREGTECH6(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.GREGTECH6).addCommonMixins(new String[]{"gt6.MixinAdvancedCraftingXToY", "gt6.MixinGT6_Main", "gt6.MixinCR"}).addClientMixins(new String[]{"gt6.MixinGT_API_Proxy_Client"})),
    RACE_CONDITION_LOGGING(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.fixLoginRaceCondition).addCommonMixins(new String[]{"core.MixinNetworkDispatcher", "core.MixinNetworkManager", "core.MixinEmbeddedChannel"}).addClientMixins(new String[]{"core.MixinNetHandlerLoginClient"})),
    MATTER_OVERDRIVE(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.MATTER_OVERDRIVE).addCommonMixins(new String[]{"mo.MixinMatterRegistry", "mo.MixinMatterRegistrationHandler", "mo.MixinVersionCheckHandler"})),
    CHUNK_PREGENERATOR(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.CHUNK_PREGENERATOR).addCommonMixins(new String[]{"pregen.MixinChunkProcessor", "pregen.MixinChunkHelper"})),
    THAUMCRAFT_HASHING(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.TC4TWEAKS).setApplyIf(() -> ArchaicConfig.betterThaumcraftHashing).addCommonMixins(new String[]{"tc4tweaks.MixinGenerateItemHash", "tc4tweaks.MixinMappingThread"})),
    MAX_RENDER_DISTANCE(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.raiseMaxRenderDistance).addExcludedMod((ITargetMod)TargetedMod.OPTIFINE).addExcludedMod((ITargetMod)TargetedMod.FASTCRAFT).addCommonMixins(new String[]{"renderdistance.MixinPlayerManager"}).addClientMixins(new String[]{"renderdistance.MixinGameSettings", "renderdistance.MixinRenderGlobal"})),
    EXTRA_UTILS(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.EXTRAUTILS).addCommonMixins(new String[]{"extrautils.MixinEventHandlerSiege", "extrautils.MixinEventHandlerServer", "extrautils.MixinItemDivisionSigil", "extrautils.MixinTileEntityTrashCan"})),
    WORLD_UPDATE_ENTITIES(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.HODGEPODGE).addCommonMixins(new String[]{"core.MixinWorld_UpdateEntities"})),
    ITEM_LAG_REDUCTION(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.SHIPSMOD).setApplyIf(() -> ArchaicConfig.itemLagReduction).addCommonMixins(new String[]{"core.MixinEntityItem"})),
    MIXINMODCANDIDATE(new ArchaicBuilder().setPhase(IBaseTransformer.Phase.EARLY).addExcludedMod((ITargetMod)TargetedMod.COFHCORE).addCommonMixins(new String[]{"core.MixinModCandidate"})),
    chickenchunks_MixinPlayerChunkViewerManager(new ArchaicBuilder().addCommonMixins("chickenchunks.MixinPlayerChunkViewerManager").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.CHICKENCHUNKS)),
    core_MixinEntityLivingBase_EarlyXpDrop(new ArchaicBuilder().addCommonMixins("core.MixinEntityLivingBase_EarlyXpDrop").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.dropXpImmediatelyOnDeath)),
    core_MixinSwampHut(new ArchaicBuilder().addCommonMixins("core.MixinSwampHut").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.fixEntityStructurePersistence)),
    mrtjp_MixinBlockUpdateHandler(new ArchaicBuilder().addCommonMixins("mrtjp.MixinBlockUpdateHandler").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.MRTJPCORE)),
    projecte_MixinRecipeShapelessHidden(new ArchaicBuilder().addCommonMixins("projecte.MixinRecipeShapelessHidden").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.PROJECTE)),
    thermal_MixinTECraftingHandler(new ArchaicBuilder().addCommonMixins("thermal.MixinTECraftingHandler").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.THERMALEXPANSION)),
    core_MixinSkinManager(new ArchaicBuilder().addClientMixins("core.MixinSkinManager").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.fixSkinMemoryLeak)),
    core_MixinWorldRenderer(new ArchaicBuilder().addClientMixins("core.MixinWorldRenderer").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> !Boolean.parseBoolean(System.getProperty("archaicFix.disableMC129", "false")))),
    core_MixinRenderItem(new ArchaicBuilder().addClientMixins("core.MixinRenderItem").setPhase(IBaseTransformer.Phase.EARLY).setApplyIf(() -> ArchaicConfig.forceFancyItems)),
    divinerpg_MixinEntitySparkler(new ArchaicBuilder().addClientMixins("divinerpg.MixinEntitySparkler").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.DIVINERPG)),
    optifine_MixinVersionCheckThread(new ArchaicBuilder().addClientMixins("optifine.MixinVersionCheckThread").setPhase(IBaseTransformer.Phase.EARLY).addRequiredMod((ITargetMod)TargetedMod.OPTIFINE).setApplyIf(() -> ArchaicConfig.disableOFVersionCheck)),
    mekanism_MixinGenHandler(new ArchaicBuilder().addCommonMixins("mekanism.MixinGenHandler").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.MEKANISM)),
    thermal_MixinBlockOre(new ArchaicBuilder().addCommonMixins("thermal.MixinBlockOre").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.THERMALFOUNDATION)),
    botania_MixinBlockSpecialFlower(new ArchaicBuilder().addCommonMixins("botania.MixinBlockSpecialFlower").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.BOTANIA)),
    journeymap_MixinTileDrawStep(new ArchaicBuilder().addClientMixins("journeymap.MixinTileDrawStep").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.JOURNEYMAP).setApplyIf(() -> ArchaicConfig.removeJourneymapDebug)),
    aoa_MixinProjectileEntities(new ArchaicBuilder().addClientMixins("aoa.MixinProjectileEntities").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.ADVENT_OF_ASCENSION)),
    am2_MixinPlayerTracker(new ArchaicBuilder().addCommonMixins("am2.MixinPlayerTracker").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.ARS_MAGICA_2)),
    foodplus_MixinUpdater(new ArchaicBuilder().addCommonMixins("foodplus.MixinUpdater").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.FOODPLUS).setApplyIf(() -> ArchaicConfig.disableFoodPlusUpdates)),
    waystones_MixinItemWarpStone(new ArchaicBuilder().addCommonMixins("waystones.MixinItemWarpStone").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.WAYSTONES)),
    ae2_MixinNEIItemRender(new ArchaicBuilder().addClientMixins("ae2.MixinNEIItemRender").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.AE2).setApplyIf(() -> ArchaicConfig.disableAE2NEIItemRendering)),
    dragonapi_MixinReikaWorldHelper(new ArchaicBuilder().addCommonMixins("dragonapi.MixinReikaWorldHelper").setPhase(IBaseTransformer.Phase.LATE).setApplyIf(() -> DragonAPIHelper.isVersionInInclusiveRange(0, 'a', 31, 'b') && !Boolean.parseBoolean(System.getProperty("archaicFix.disableFastReikaWorldHelper", "false")))),
    diversity_MixinServerHandler(new ArchaicBuilder().addCommonMixins("diversity.MixinServerHandler").setPhase(IBaseTransformer.Phase.LATE).addRequiredMod((ITargetMod)TargetedMod.DIVERSITY));

    private final MixinBuilder builder;

    public MixinBuilder getBuilder() {
        return this.builder;
    }

    private Mixin(MixinBuilder builder) {
        this.builder = builder;
    }

    static class ArchaicBuilder
    extends MixinBuilder {
        ArchaicBuilder() {
        }

        public MixinBuilder addCommonMixins(String ... mixins) {
            for (int i = 0; i < mixins.length; ++i) {
                mixins[i] = "common." + mixins[i];
            }
            return super.addCommonMixins(mixins);
        }

        public MixinBuilder addClientMixins(String ... mixins) {
            for (int i = 0; i < mixins.length; ++i) {
                mixins[i] = "client." + mixins[i];
            }
            return super.addClientMixins(mixins);
        }

        public MixinBuilder addSidedMixins(@Nonnull IBaseTransformer.Side side, String ... mixins) {
            if (side == IBaseTransformer.Side.COMMON) {
                return this.addCommonMixins(mixins);
            }
            if (side == IBaseTransformer.Side.CLIENT) {
                return this.addClientMixins(mixins);
            }
            return super.addSidedMixins(side, mixins);
        }
    }
}

