/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.renderer;

import com.github.lunatrius.core.util.vector.Vector3d;
import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicChunk;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import java.util.Comparator;

public class RendererSchematicChunkComparator
implements Comparator<RendererSchematicChunk> {
    private final Vector3d position = new Vector3d();
    private final Vector3d schematicPosition = new Vector3d();

    @Override
    public int compare(RendererSchematicChunk rendererSchematicChunk1, RendererSchematicChunk rendererSchematicChunk2) {
        if (rendererSchematicChunk1.isInFrustrum && !rendererSchematicChunk2.isInFrustrum) {
            return -1;
        }
        if (!rendererSchematicChunk1.isInFrustrum && rendererSchematicChunk2.isInFrustrum) {
            return 1;
        }
        double dist1 = this.position.lengthSquaredTo(rendererSchematicChunk1.centerPosition);
        double dist2 = this.position.lengthSquaredTo(rendererSchematicChunk2.centerPosition);
        return Double.compare(dist1, dist2);
    }

    public void setPosition(Vector3i position) {
        this.position.set(ClientProxy.playerPosition).sub(position.toVector3d(this.schematicPosition));
    }
}

