/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.Config;
import com.glodblock.github.network.SPacketMEFluidInvUpdate;
import com.glodblock.github.network.SPacketMEItemInvUpdate;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayerMP;

public class SPacketMEUpdateBuffer {
    private static ScheduledExecutorService executor;
    private static ScheduledFuture<?> task;
    private static final Map<EntityPlayerMP, LinkedHashSet<IAEItemStack>> itemBuffer;
    private static final Map<EntityPlayerMP, LinkedHashSet<IAEFluidStack>> fluidBuffer;

    public static void init() {
        executor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName("AE2FC Network worker");
            thread.setDaemon(true);
            thread.setPriority(6);
            return thread;
        });
        task = executor.scheduleAtFixedRate(SPacketMEUpdateBuffer::sendBuffer, 0L, Config.packetRate, TimeUnit.MILLISECONDS);
    }

    public static void disable() {
        if (task != null) {
            task.cancel(false);
        }
        if (executor != null) {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleItemUpdate(EntityPlayerMP player, List<IAEItemStack> stacks) {
        Map<EntityPlayerMP, LinkedHashSet<IAEItemStack>> map = itemBuffer;
        synchronized (map) {
            if (!itemBuffer.containsKey(player)) {
                itemBuffer.put(player, new LinkedHashSet(1024));
            }
            LinkedHashSet<IAEItemStack> buffer = itemBuffer.get(player);
            stacks.forEach(s -> buffer.add(s.copy()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleFluidUpdate(EntityPlayerMP player, List<IAEFluidStack> stacks) {
        Map<EntityPlayerMP, LinkedHashSet<IAEItemStack>> map = itemBuffer;
        synchronized (map) {
            if (!fluidBuffer.containsKey(player)) {
                fluidBuffer.put(player, new LinkedHashSet(1024));
            }
            LinkedHashSet<IAEFluidStack> buffer = fluidBuffer.get(player);
            stacks.forEach(s -> buffer.add(s.copy()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBuffer() {
        Map<EntityPlayerMP, LinkedHashSet<IAEItemStack>> map = itemBuffer;
        synchronized (map) {
            itemBuffer.forEach((player, updates) -> {
                if (updates.isEmpty()) {
                    return;
                }
                int i = 0;
                SPacketMEItemInvUpdate packet = new SPacketMEItemInvUpdate(false);
                Iterator it = updates.iterator();
                while (it.hasNext()) {
                    if (i < Config.packetSize) {
                        packet.appendItem((IAEItemStack)it.next());
                        it.remove();
                        ++i;
                        continue;
                    }
                    FluidCraft.proxy.netHandler.sendTo(packet, (EntityPlayerMP)player);
                    packet = new SPacketMEItemInvUpdate(false);
                    i = 0;
                }
                packet.setResort(true);
                FluidCraft.proxy.netHandler.sendTo(packet, (EntityPlayerMP)player);
            });
            fluidBuffer.forEach((player, updates) -> {
                if (updates.isEmpty()) {
                    return;
                }
                int i = 0;
                SPacketMEFluidInvUpdate packet = new SPacketMEFluidInvUpdate(false);
                Iterator it = updates.iterator();
                while (it.hasNext()) {
                    if (i < Config.packetSize) {
                        packet.appendFluid((IAEFluidStack)it.next());
                        it.remove();
                        ++i;
                        continue;
                    }
                    FluidCraft.proxy.netHandler.sendTo(packet, (EntityPlayerMP)player);
                    packet = new SPacketMEFluidInvUpdate(false);
                    i = 0;
                }
                packet.setResort(true);
                FluidCraft.proxy.netHandler.sendTo(packet, (EntityPlayerMP)player);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(EntityPlayerMP player) {
        Map<EntityPlayerMP, LinkedHashSet<IAEItemStack>> map = itemBuffer;
        synchronized (map) {
            if (itemBuffer.containsKey(player)) {
                itemBuffer.get(player).clear();
            }
            if (fluidBuffer.containsKey(player)) {
                fluidBuffer.get(player).clear();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            SPacketMEUpdateBuffer.clear((EntityPlayerMP)event.player);
        }
    }

    static {
        itemBuffer = new HashMap<EntityPlayerMP, LinkedHashSet<IAEItemStack>>();
        fluidBuffer = new HashMap<EntityPlayerMP, LinkedHashSet<IAEFluidStack>>();
    }
}

