/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei;

import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import com.glodblock.github.client.gui.GuiFluidCraftingWireless;
import com.glodblock.github.nei.FluidPatternTerminalRecipeTransferHandler;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FluidCraftingTransferHandler
implements IOverlayHandler {
    public static final FluidCraftingTransferHandler INSTANCE = new FluidCraftingTransferHandler();

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            if (firstGui instanceof GuiFluidCraftingWireless && FluidPatternTerminalRecipeTransferHandler.craftSet.contains(recipe.getOverlayIdentifier())) {
                PacketNEIRecipe packet = new PacketNEIRecipe(this.packIngredients(firstGui, ingredients));
                NetworkHandler.instance.sendToServer((AppEngPacket)packet);
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    private NBTTagCompound packIngredients(GuiContainer gui, List<PositionedStack> ingredients) throws IOException {
        NBTTagCompound recipe = new NBTTagCompound();
        block0: for (PositionedStack positionedStack : ingredients) {
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            for (Object o : gui.field_147002_h.field_75151_b) {
                Slot slot;
                if (!(o instanceof SlotCraftingMatrix) && !(o instanceof SlotFakeCraftingMatrix) || (slot = (Slot)o).getSlotIndex() != col + row * 3) continue;
                NBTTagList tags = new NBTTagList();
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (int x = 0; x < positionedStack.items.length; ++x) {
                    if (Platform.isRecipePrioritized((ItemStack)positionedStack.items[x])) {
                        list.add(0, positionedStack.items[x]);
                        continue;
                    }
                    list.add(positionedStack.items[x]);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.func_77955_b(tag);
                    tags.func_74742_a((NBTBase)tag);
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                continue block0;
            }
        }
        return recipe;
    }
}

