/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod;

import com.glodblock.github.coremod.FluidCraftCore;
import com.glodblock.github.coremod.transform.CraftingCpuTransformer;
import com.glodblock.github.coremod.transform.CraftingGridCacheTransformer;
import com.glodblock.github.coremod.transform.CraftingTreeNodeTransformer;
import com.glodblock.github.coremod.transform.DualityInterfaceTransformer;
import com.glodblock.github.coremod.transform.ExternalStorageRegistryTransformer;
import com.glodblock.github.coremod.transform.GuiCraftingTransformer;
import com.glodblock.github.coremod.transform.NEITransformer;
import com.gtnewhorizon.gtnhlib.asm.ASMUtil;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class FCClassTransformer
implements IClassTransformer {
    private static final Logger logger = LogManager.getLogger((String)"ASM AE2FC");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassMapper tform;
        switch (transformedName) {
            case "appeng.crafting.CraftingTreeNode": {
                tform = CraftingTreeNodeTransformer.INSTANCE;
                break;
            }
            case "appeng.me.cache.CraftingGridCache": {
                tform = CraftingGridCacheTransformer.INSTANCE;
                break;
            }
            case "appeng.me.cluster.implementations.CraftingCPUCluster": {
                tform = CraftingCpuTransformer.INSTANCE;
                break;
            }
            case "appeng.helpers.DualityInterface": {
                tform = DualityInterfaceTransformer.INSTANCE;
                break;
            }
            case "appeng.client.gui.implementations.GuiCraftingCPU": 
            case "appeng.client.gui.implementations.GuiCraftConfirm": 
            case "net.p455w0rd.wirelesscraftingterminal.client.gui.GuiCraftConfirm": 
            case "appeng.client.gui.widgets.GuiCraftingTree": {
                tform = GuiCraftingTransformer.INSTANCE;
                break;
            }
            case "appeng.integration.modules.NEI": {
                tform = NEITransformer.INSTANCE;
                break;
            }
            case "appeng.core.features.registries.ExternalStorageRegistry": {
                tform = ExternalStorageRegistryTransformer.INSTANCE;
                break;
            }
            default: {
                return basicClass;
            }
        }
        logger.debug("Transforming class: " + transformedName);
        byte[] bytes = tform.transformClass(basicClass);
        if (FluidCraftCore.DUMP_CLASSES()) {
            ASMUtil.saveAsRawClassFile((byte[])basicClass, (String)(transformedName + "_PRE"), (Object)this);
            ASMUtil.saveAsRawClassFile((byte[])bytes, (String)(transformedName + "_POST"), (Object)this);
        }
        return bytes;
    }

    public static abstract class ClassMapper {
        public final byte[] transformClass(byte[] code) {
            ClassReader reader = new ClassReader(code);
            ClassWriter writer = new ClassWriter(reader, this.getWriteFlags());
            reader.accept(this.getClassMapper((ClassVisitor)writer), 8);
            return writer.toByteArray();
        }

        protected int getWriteFlags() {
            return 0;
        }

        protected abstract ClassVisitor getClassMapper(ClassVisitor var1);
    }
}

