/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.common.item.ItemBaseInfinityStorageCell;
import com.glodblock.github.common.item.ItemFluidVoidStorageCell;
import com.glodblock.github.common.storage.CreativeFluidCellInventory;
import com.glodblock.github.common.storage.FluidCellInventoryHandler;
import com.glodblock.github.common.storage.FluidVoidStorageCellInventory;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.crossmod.extracells.storage.ProxyFluidCellInventory;
import com.glodblock.github.crossmod.extracells.storage.ProxyFluidStorageCell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidCellInventory
implements IFluidCellInventory {
    protected static final String FLUID_TYPE_TAG = "ft";
    protected static final String FLUID_COUNT_TAG = "fc";
    protected static final String FLUID_SLOT = "#";
    protected static final String FLUID_SLOT_COUNT = "@";
    protected IStorageFluidCell cellType;
    protected static String[] fluidSlots;
    protected static String[] fluidSlotCount;
    protected final ItemStack cellItem;
    private final ISaveProvider container;
    private final int MAX_TYPE = 63;
    protected long storedFluidCount;
    protected short storedFluids;
    protected IItemList<IAEFluidStack> cellFluids;
    protected final NBTTagCompound tagCompound;
    public static final int singleByteAmount = 2048;
    private boolean cardVoidOverflow = false;
    private boolean cardDistribution = false;
    private byte restrictionTypes = 0;
    private long restrictionLong = 0L;

    public FluidCellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellType = null;
        this.cellItem = o;
        Item type = this.cellItem.func_77973_b();
        if (type instanceof IStorageFluidCell) {
            this.cellType = (IStorageFluidCell)this.cellItem.func_77973_b();
        }
        if (this.cellType == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (!this.cellType.isStorageCell(this.cellItem)) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (fluidSlots == null) {
            fluidSlots = new String[63];
            fluidSlotCount = new String[63];
            for (int x = 0; x < 63; ++x) {
                FluidCellInventory.fluidSlots[x] = FLUID_SLOT + x;
                FluidCellInventory.fluidSlotCount[x] = FLUID_SLOT_COUNT + x;
            }
        }
        IInventory upgrades = this.getUpgradesInventory();
        block5: for (int x = 0; x < upgrades.func_70302_i_(); ++x) {
            Upgrades u;
            ItemStack is = upgrades.func_70301_a(x);
            if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
            switch (u) {
                case VOID_OVERFLOW: {
                    this.cardVoidOverflow = true;
                    continue block5;
                }
                case DISTRIBUTION: {
                    this.cardDistribution = true;
                    continue block5;
                }
            }
        }
        this.container = container;
        this.tagCompound = Platform.openNbtData((ItemStack)o);
        this.storedFluids = this.tagCompound.func_74765_d(FLUID_TYPE_TAG);
        this.storedFluidCount = this.tagCompound.func_74763_f(FLUID_COUNT_TAG);
        this.restrictionTypes = this.tagCompound.func_74771_c("cellRestrictionTypes");
        this.restrictionLong = this.tagCompound.func_74763_f("cellRestrictionAmount");
        this.cellFluids = null;
    }

    public static IMEInventoryHandler<IAEFluidStack> getCell(ItemStack o, ISaveProvider container2) {
        try {
            if (o.func_77973_b() instanceof ItemBaseInfinityStorageCell) {
                return new FluidCellInventoryHandler(new CreativeFluidCellInventory(o, container2));
            }
            if (o.func_77973_b() instanceof ProxyFluidStorageCell) {
                return new FluidCellInventoryHandler(new ProxyFluidCellInventory(o, container2));
            }
            if (o.func_77973_b() instanceof ItemFluidVoidStorageCell) {
                return new FluidCellInventoryHandler(new FluidVoidStorageCellInventory(o, container2));
            }
            return new FluidCellInventoryHandler(new FluidCellInventory(o, container2));
        }
        catch (AppEngException e) {
            return null;
        }
    }

    public static boolean isCell(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item type = itemStack.func_77973_b();
        if (type instanceof IStorageFluidCell) {
            return ((IStorageFluidCell)type).isStorageCell(itemStack);
        }
        return false;
    }

    @Override
    public ItemStack getItemStack() {
        return this.cellItem;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return this.cellType.getIdleDrain(is);
    }

    @Override
    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    @Override
    public boolean canHoldNewFluid() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedFluidCount() > 0) && this.getRemainingFluidTypes() > 0L;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getBytes(this.cellItem);
    }

    @Override
    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    @Override
    public long getUsedBytes() {
        long bytesForFluidCount = (this.getStoredFluidCount() + (long)this.getUnusedFluidCount()) / 2048L;
        return this.getStoredFluidTypes() * (long)this.getBytesPerType() + bytesForFluidCount;
    }

    @Override
    public long getTotalFluidTypes() {
        if (this.restrictionTypes > 0) {
            return this.restrictionTypes;
        }
        return this.cellType.getTotalTypes(this.cellItem);
    }

    public long getMaxFluidTypes() {
        return this.cellType.getTotalTypes(this.cellItem);
    }

    @Override
    public long getStoredFluidCount() {
        return this.storedFluidCount;
    }

    @Override
    public long getStoredFluidTypes() {
        return this.storedFluids;
    }

    @Override
    public long getRemainingFluidTypes() {
        long basedOnStorage = this.getFreeBytes() / (long)Math.max(1, this.getBytesPerType());
        long baseOnTotal = this.getTotalFluidTypes() - this.getStoredFluidTypes();
        return Math.min(basedOnStorage, baseOnTotal);
    }

    @Override
    public long getRemainingFluidCount() {
        if (this.restrictionLong > 0L) {
            return Math.min(this.restrictionLong - this.getStoredFluidCount(), this.getFreeBytes() * 2048L + (long)this.getUnusedFluidCount());
        }
        long remaining = this.getFreeBytes() * 2048L + (long)this.getUnusedFluidCount();
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public long getRemainingFluidCountDist(IAEFluidStack l) {
        long types = 0L;
        int i = 0;
        while ((long)i < this.getTotalFluidTypes()) {
            if (this.getConfigInventory().func_70301_a(i) != null) {
                ++types;
            }
            ++i;
        }
        if (types == 0L) {
            types = this.getTotalFluidTypes();
        }
        long remaining = l != null ? (this.restrictionLong > 0L ? Math.min(this.restrictionLong / types - l.getStackSize(), this.getRemainingFluidCount()) : (this.getTotalBytes() / types - (long)this.getBytesPerType()) * 2048L - l.getStackSize()) : (this.restrictionLong > 0L ? Math.min(this.restrictionLong / types, (this.getTotalBytes() / types - (long)this.getBytesPerType()) * 2048L) : (this.getTotalBytes() / types - (long)this.getBytesPerType()) * 2048L);
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public int getUnusedFluidCount() {
        int div = (int)(this.getStoredFluidCount() % 2048L);
        if (div == 0) {
            return 0;
        }
        return 2048 - div;
    }

    @Override
    public int getStatusForCell() {
        if (this.getUsedBytes() == 0L) {
            return 1;
        }
        if (this.canHoldNewFluid()) {
            return 2;
        }
        if (this.getRemainingFluidCount() > 0L) {
            return 3;
        }
        return 4;
    }

    protected void loadCellFluids() {
        if (this.cellFluids == null) {
            this.cellFluids = AEApi.instance().storage().createFluidList();
        }
        this.cellFluids.resetStatus();
        int types = (int)this.getStoredFluidTypes();
        for (int x = 0; x < types; ++x) {
            FluidStack t = FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.tagCompound.func_74775_l(fluidSlots[x]));
            AEFluidStack aet = AEFluidStack.create((Object)t);
            if (aet == null) continue;
            aet.setStackSize(this.tagCompound.func_74763_f(fluidSlotCount[x]));
            if (aet.getStackSize() <= 0L) continue;
            this.cellFluids.add((IAEStack)aet);
        }
    }

    protected IItemList<IAEFluidStack> getCellFluids() {
        if (this.cellFluids == null) {
            this.loadCellFluids();
        }
        return this.cellFluids;
    }

    private void updateFluidCount(long delta) {
        this.storedFluidCount += delta;
        this.tagCompound.func_74772_a(FLUID_COUNT_TAG, this.storedFluidCount);
    }

    private void saveChanges() {
        long fluidCount = 0L;
        int x = 0;
        for (IAEFluidStack v : this.cellFluids) {
            fluidCount += v.getStackSize();
            NBTBase c = this.tagCompound.func_74781_a(fluidSlots[x]);
            if (c instanceof NBTTagCompound) {
                v.writeToNBT((NBTTagCompound)c);
            } else {
                NBTTagCompound g = new NBTTagCompound();
                v.writeToNBT(g);
                this.tagCompound.func_74782_a(fluidSlots[x], (NBTBase)g);
            }
            this.tagCompound.func_74772_a(fluidSlotCount[x], v.getStackSize());
            ++x;
        }
        int oldStoredFluids = this.storedFluids;
        this.storedFluids = (short)this.cellFluids.size();
        if (this.cellFluids.isEmpty()) {
            this.tagCompound.func_82580_o(FLUID_TYPE_TAG);
        } else {
            this.tagCompound.func_74777_a(FLUID_TYPE_TAG, this.storedFluids);
        }
        this.storedFluidCount = fluidCount;
        if (fluidCount == 0L) {
            this.tagCompound.func_82580_o(FLUID_COUNT_TAG);
        } else {
            this.tagCompound.func_74772_a(FLUID_COUNT_TAG, fluidCount);
        }
        while (x < oldStoredFluids && x < 63) {
            this.tagCompound.func_82580_o(fluidSlots[x]);
            this.tagCompound.func_82580_o(fluidSlotCount[x]);
            ++x;
        }
        if (this.container != null) {
            this.container.saveChanges((IMEInventory)this);
        }
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        long remainingFluidCount;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        IAEFluidStack l = (IAEFluidStack)this.getCellFluids().findPrecise((IAEStack)input);
        if (l != null) {
            long remainingFluidSlots = this.cardDistribution ? this.getRemainingFluidCountDist(l) : this.getRemainingFluidCount();
            if (remainingFluidSlots <= 0L) {
                if (this.cardVoidOverflow) {
                    return null;
                }
                return input;
            }
            if (input.getStackSize() > remainingFluidSlots) {
                IAEFluidStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingFluidSlots);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingFluidSlots);
                    this.updateFluidCount(remainingFluidSlots);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.updateFluidCount(input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewFluid() && (remainingFluidCount = this.cardDistribution ? this.getRemainingFluidCountDist(null) : Math.min(this.getRemainingFluidCount(), this.getFreeBytes() * 2048L + (long)this.getUnusedFluidCount() - (long)this.getBytesPerType() * 2048L)) > 0L) {
            if (input.getStackSize() > remainingFluidCount) {
                IAEFluidStack toReturn = input.copy();
                toReturn.decStackSize(remainingFluidCount);
                if (mode == Actionable.MODULATE) {
                    IAEFluidStack toWrite = input.copy();
                    toWrite.setStackSize(remainingFluidCount);
                    this.cellFluids.add((IAEStack)toWrite);
                    this.updateFluidCount(toWrite.getStackSize());
                    this.saveChanges();
                }
                return toReturn;
            }
            if (mode == Actionable.MODULATE) {
                this.updateFluidCount(input.getStackSize());
                this.cellFluids.add((IAEStack)input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = request.getStackSize();
        IAEFluidStack results = null;
        IAEFluidStack l = (IAEFluidStack)this.getCellFluids().findPrecise((IAEStack)request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    this.updateFluidCount(-l.getStackSize());
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.updateFluidCount(-size);
                    this.saveChanges();
                }
            }
        }
        return results;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out, int iteration) {
        for (IAEFluidStack i : this.getCellFluids()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    public IAEFluidStack getAvailableItem(@Nonnull IAEFluidStack request, int iteration) {
        return (IAEFluidStack)this.getCellFluids().findPrecise((IAEStack)request);
    }

    @Override
    @NotNull
    public List<IAEFluidStack> getContents() {
        ArrayList<IAEFluidStack> ret = new ArrayList<IAEFluidStack>();
        for (IAEFluidStack fluid : this.getCellFluids()) {
            ret.add(fluid);
        }
        return ret;
    }

    @Override
    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.cellItem);
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public List<Object> getRestriction() {
        return Arrays.asList(this.restrictionLong, this.restrictionTypes);
    }
}

