/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.util.IOrientable;
import appeng.block.AEBaseItemBlock;
import appeng.core.features.AEFeature;
import appeng.tile.misc.TileInterface;
import appeng.util.Platform;
import com.glodblock.github.client.render.RenderBlockFluidInterface;
import com.glodblock.github.common.block.FCBaseBlock;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFluidInterface
extends FCBaseBlock {
    public BlockFluidInterface() {
        super(Material.field_151573_f, "fluid_interface");
        this.setFullBlock(true);
        this.setOpaque(true);
        this.setTileEntity(TileFluidInterface.class);
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockFluidInterface getRenderer() {
        return new RenderBlockFluidInterface();
    }

    public boolean onActivated(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileInterface tg = (TileInterface)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tg != null) {
            if (Platform.isServer()) {
                InventoryHandler.openGui(player, world, new BlockPos(x, y, z), ForgeDirection.getOrientation((int)facing), GuiType.DUAL_INTERFACE);
            }
            return true;
        }
        return false;
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        TileFluidInterface tile = (TileFluidInterface)this.getTileEntity((IBlockAccess)worldIn, x, y, z);
        if (tile != null) {
            tile.getInterfaceDuality().updateRedstoneState();
        }
    }

    protected boolean hasCustomRotation() {
        return true;
    }

    protected void customRotateBlock(IOrientable rotatable, ForgeDirection axis) {
        if (rotatable instanceof TileInterface) {
            ((TileInterface)rotatable).setSide(axis);
        }
    }

    @Override
    public BlockFluidInterface register() {
        GameRegistry.registerBlock((Block)this, AEBaseItemBlock.class, (String)"fluid_interface");
        GameRegistry.registerTileEntity(TileFluidInterface.class, (String)"fluid_interface");
        this.func_149647_a(FluidCraftingTabs.INSTANCE);
        return this;
    }
}

