/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.layout;

import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IParentWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.AbstractScrollWidget;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollData;
import com.cleanroommc.modularui.widget.scroll.VerticalScrollData;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widget.sizer.Box;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Grid
extends AbstractScrollWidget<IWidget, Grid>
implements ILayoutWidget,
IParentWidget<IWidget, Grid> {
    private final List<List<IWidget>> matrix = new ArrayList<List<IWidget>>();
    private final Box minElementMargin = new Box();
    private int minRowHeight = 5;
    private int minColWidth = 5;
    private Alignment alignment = Alignment.Center;
    private boolean dirty = false;
    private boolean collapseDisabledChild = false;

    public Grid() {
        super(null, null);
    }

    @Override
    public void onInit() {
        super.onInit();
        int maxRowSize = 0;
        for (List<IWidget> row : this.matrix) {
            maxRowSize = Math.max(maxRowSize, row.size());
        }
        for (List<IWidget> row : this.matrix) {
            while (row.size() < maxRowSize) {
                row.add(null);
            }
        }
    }

    private int getElementWidth(Area area) {
        return area.width + Math.max(area.getMargin().left, this.minElementMargin.left) + Math.max(area.getMargin().right, this.minElementMargin.right);
    }

    private int getElementHeight(Area area) {
        return area.height + Math.max(area.getMargin().top, this.minElementMargin.top) + Math.max(area.getMargin().bottom, this.minElementMargin.bottom);
    }

    @Override
    public void layoutWidgets() {
        IntArrayList rowSizes = new IntArrayList();
        IntArrayList colSizes = new IntArrayList();
        int i = 0;
        for (List<IWidget> row : this.matrix) {
            int j = 0;
            rowSizes.add(this.minRowHeight);
            for (IWidget child : row) {
                if (i == 0) {
                    colSizes.add(this.minColWidth);
                }
                if (!this.shouldIgnoreChildSize(child)) {
                    rowSizes.set(i, Math.max(rowSizes.getInt(i), this.getElementHeight(child.getArea())));
                    colSizes.set(j, Math.max(colSizes.getInt(j), this.getElementWidth(child.getArea())));
                }
                ++j;
            }
            ++i;
        }
        int x = 0;
        int y = 0;
        for (int r = 0; r < rowSizes.size(); ++r) {
            x = 0;
            int height = rowSizes.get(r);
            for (int c = 0; c < colSizes.size(); ++c) {
                int width = colSizes.get(c);
                IWidget child = this.matrix.get(r).get(c);
                if (child != null) {
                    child.getArea().rx = (int)((float)x + (float)(width - child.getArea().width) * this.alignment.x);
                    child.getArea().ry = (int)((float)y + (float)(height - child.getArea().height) * this.alignment.y);
                    child.resizer().setPosResized(true, true);
                }
                x += width;
            }
            y += height;
        }
        if (this.getScrollArea().getScrollX() != null) {
            this.getScrollArea().getScrollX().setScrollSize(x);
        }
        if (this.getScrollArea().getScrollY() != null) {
            this.getScrollArea().getScrollY().setScrollSize(y);
        }
    }

    @Override
    public boolean shouldIgnoreChildSize(IWidget child) {
        return child == null || this.collapseDisabledChild && !child.isEnabled();
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        if (this.dirty) {
            this.makeFlatList();
            this.dirty = false;
        }
        return super.getChildren();
    }

    private void makeFlatList() {
        super.getChildren().clear();
        super.getChildren().addAll(this.matrix.stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public int getDefaultHeight() {
        int h = 0;
        for (List<IWidget> row : this.matrix) {
            int rowHeight = 0;
            for (IWidget child : row) {
                if (this.shouldIgnoreChildSize(child)) continue;
                rowHeight = Math.max(rowHeight, this.getElementHeight(child.getArea()));
            }
            h += Math.min(rowHeight, this.minRowHeight);
        }
        return h;
    }

    @Override
    public int getDefaultWidth() {
        IntArrayList colSizes = new IntArrayList();
        int i = 0;
        for (List<IWidget> row : this.matrix) {
            int j = 0;
            for (IWidget child : row) {
                if (i == 0) {
                    colSizes.add(this.minColWidth);
                }
                if (!this.shouldIgnoreChildSize(child)) {
                    colSizes.set(j, Math.max(colSizes.getInt(j), this.getElementWidth(child.getArea())));
                }
                ++j;
            }
            ++i;
        }
        int w = 0;
        IntListIterator intListIterator = colSizes.iterator();
        while (intListIterator.hasNext()) {
            int colWidth = (Integer)intListIterator.next();
            w += colWidth;
        }
        return w;
    }

    public <I extends IWidget> Grid matrix(List<List<I>> matrix) {
        this.matrix.clear();
        for (List<I> row : matrix) {
            this.matrix.add(row);
        }
        this.dirty = true;
        return this;
    }

    public Grid row(List<IWidget> row) {
        this.matrix.add(row);
        this.dirty = true;
        return this;
    }

    public Grid row(IWidget ... row) {
        Objects.requireNonNull(row);
        return this.row(Arrays.asList(row));
    }

    @Override
    public boolean addChild(IWidget child, int index) {
        if (child == this || this.getChildren().contains(child)) {
            return false;
        }
        if (index < 0) {
            index = this.getChildren().size() + index + 1;
        }
        super.getChildren().add(index, child);
        if (this.isValid()) {
            child.initialise(this);
        }
        this.onChildAdd(child);
        this.dirty = true;
        return true;
    }

    @Override
    public Grid child(@Nullable IWidget widget) {
        this.matrix.get(this.matrix.size() - 1).add(widget);
        this.dirty = true;
        return this;
    }

    public Grid nextRow() {
        this.matrix.add(new ArrayList());
        return this;
    }

    public <T, I extends IWidget> Grid mapTo(int rowLength, @NotNull List<T> list, @NotNull IndexedElementMapper<T, I> widgetCreator) {
        Objects.requireNonNull(widgetCreator);
        Objects.requireNonNull(list);
        return this.matrix(Grid.mapToMatrix(rowLength, list, widgetCreator));
    }

    public <I extends IWidget> Grid mapTo(int rowLength, @NotNull List<I> list) {
        Objects.requireNonNull(list);
        return this.mapTo(rowLength, list.size(), list::get);
    }

    public <I extends IWidget> Grid mapTo(int rowLength, int size, @NotNull IntFunction<I> widgetCreator) {
        Objects.requireNonNull(widgetCreator);
        return this.matrix(Grid.mapToMatrix(rowLength, size, widgetCreator));
    }

    public Grid minColWidth(int minColWidth) {
        this.minColWidth = minColWidth;
        return this;
    }

    public Grid minRowHeight(int minRowHeight) {
        this.minRowHeight = minRowHeight;
        return this;
    }

    public Grid alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public Grid scrollable() {
        return this.scrollable(new VerticalScrollData(), new HorizontalScrollData());
    }

    public Grid scrollable(ScrollData data) {
        this.getScrollArea().setScrollData(data);
        return this;
    }

    public Grid scrollable(VerticalScrollData data1, HorizontalScrollData data2) {
        this.getScrollArea().setScrollData(data1);
        this.getScrollArea().setScrollData(data2);
        return this;
    }

    public Grid minElementMargin(int left, int right, int top, int bottom) {
        this.minElementMargin.all(left, right, top, bottom);
        return (Grid)this.getThis();
    }

    public Grid minElementMargin(int horizontal, int vertical) {
        this.minElementMargin.all(horizontal, vertical);
        return (Grid)this.getThis();
    }

    public Grid minElementMargin(int all) {
        this.minElementMargin.all(all);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginLeft(int val) {
        this.minElementMargin.left(val);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginRight(int val) {
        this.minElementMargin.right(val);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginTop(int val) {
        this.minElementMargin.top(val);
        return (Grid)this.getThis();
    }

    public Grid minElementMarginBottom(int val) {
        this.minElementMargin.bottom(val);
        return (Grid)this.getThis();
    }

    public Grid collapseDisabledChild() {
        this.collapseDisabledChild = true;
        return (Grid)this.getThis();
    }

    public static <T, I extends IWidget> List<List<I>> mapToMatrix(int rowLength, List<T> list, IndexedElementMapper<T, I> widgetCreator) {
        return Grid.mapToMatrix(rowLength, list.size(), (int i) -> (IWidget)widgetCreator.apply(i, list.get(i)));
    }

    public static <I extends IWidget> List<List<I>> mapToMatrix(int rowLength, int size, IntFunction<I> widgetCreator) {
        ArrayList<List<I>> matrix = new ArrayList<List<I>>();
        for (int i = 0; i < size; ++i) {
            int r = i / rowLength;
            if (r == matrix.size()) {
                matrix.add(new ArrayList());
            }
            ((List)matrix.get(r)).add((IWidget)widgetCreator.apply(i));
        }
        return matrix;
    }

    public static interface IndexedElementMapper<T, I> {
        public I apply(int var1, T var2);
    }
}

