/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.mathcollection;

import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.mXparser;

public class PrimesCache {
    public static final int DEFAULT_MAX_NUM_IN_CACHE = 10000000;
    public static final boolean CACHE_EMPTY = false;
    public static final boolean CACHING_FINISHED = true;
    public static final int IS_PRIME = 1;
    public static final int IS_NOT_PRIME = 0;
    public static final int NOT_IN_CACHE = -1;
    int maxNumInCache;
    int numberOfPrimes;
    double computingTime;
    boolean cacheStatus;
    boolean[] isPrime;
    boolean initSuccessful;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EratosthenesSieve() {
        long startTime = System.currentTimeMillis();
        try {
            int i;
            int size = this.maxNumInCache + 1;
            if (size <= 0) {
                this.numberOfPrimes = 0;
                this.maxNumInCache = 0;
                this.initSuccessful = false;
                long endTime = System.currentTimeMillis();
                this.computingTime = (double)(endTime - startTime) / 1000.0;
                return;
            }
            this.isPrime = new boolean[size];
            this.numberOfPrimes = 0;
            this.isPrime[0] = false;
            this.isPrime[1] = false;
            for (i = 2; i <= this.maxNumInCache; ++i) {
                this.isPrime[i] = true;
                if (!mXparser.isCurrentCalculationCancelled()) continue;
                return;
            }
            i = 2;
            while (i * i <= this.maxNumInCache) {
                if (mXparser.isCurrentCalculationCancelled()) {
                    return;
                }
                if (this.isPrime[i]) {
                    int j = i;
                    while (i * j <= this.maxNumInCache) {
                        this.isPrime[i * j] = false;
                        if (mXparser.isCurrentCalculationCancelled()) {
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.initSuccessful = true;
        }
        catch (OutOfMemoryError e) {
            this.initSuccessful = false;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.computingTime = (double)(endTime - startTime) / 1000.0;
        }
    }

    private void countPrimes() {
        for (int i = 0; i <= this.maxNumInCache; ++i) {
            if (this.isPrime[i]) {
                ++this.numberOfPrimes;
            }
            if (!mXparser.isCurrentCalculationCancelled()) continue;
            return;
        }
    }

    public PrimesCache() {
        this.initSuccessful = false;
        this.cacheStatus = false;
        this.maxNumInCache = 10000000;
        this.computingTime = Double.NaN;
        this.EratosthenesSieve();
        if (this.initSuccessful) {
            this.countPrimes();
            this.cacheStatus = true;
        } else {
            this.maxNumInCache = 0;
            this.numberOfPrimes = 0;
        }
    }

    public PrimesCache(int maxNumInCache) {
        this.maxNumInCache = maxNumInCache > 2 ? Math.min(maxNumInCache, 0x7FFFFFFE) : 10000000;
        this.initSuccessful = false;
        this.cacheStatus = false;
        this.computingTime = Double.NaN;
        maxNumInCache = 10000000;
        this.EratosthenesSieve();
        if (this.initSuccessful) {
            this.countPrimes();
            this.cacheStatus = true;
        } else {
            maxNumInCache = 0;
            this.numberOfPrimes = 0;
        }
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public boolean getCacheStatus() {
        return this.cacheStatus;
    }

    public int getNumberOfPrimes() {
        return this.numberOfPrimes;
    }

    public int getMaxNumInCache() {
        return this.maxNumInCache;
    }

    public int primeTest(int n) {
        if (n <= 1) {
            return 0;
        }
        if (n <= this.maxNumInCache && this.cacheStatus) {
            if (this.isPrime[n]) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public boolean isInitSuccessful() {
        return this.initSuccessful;
    }

    boolean[] getPrimes() {
        return this.isPrime;
    }
}

