/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen.viewport;

import com.cleanroommc.modularui.api.layout.IViewport;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.viewport.GuiViewportStack;
import com.cleanroommc.modularui.screen.viewport.LocatedElement;
import com.cleanroommc.modularui.screen.viewport.TransformationMatrix;
import java.util.ArrayList;

public class LocatedWidget
extends LocatedElement<IWidget> {
    public static final LocatedWidget EMPTY = new LocatedWidget(null, TransformationMatrix.EMPTY);

    public static LocatedWidget of(IWidget widget) {
        if (widget == null) {
            return EMPTY;
        }
        IWidget parent = widget;
        ArrayList<IWidget> ancestors = new ArrayList<IWidget>();
        while (true) {
            ancestors.add(0, parent);
            if (parent instanceof ModularPanel) break;
            parent = parent.getParent();
        }
        GuiViewportStack stack = new GuiViewportStack();
        for (IWidget widget1 : ancestors) {
            if (widget1 instanceof IViewport) {
                IViewport viewport = (IViewport)((Object)widget1);
                stack.pushViewport(viewport, widget1.getArea());
                widget1.transform(stack);
                viewport.transformChildren(stack);
                continue;
            }
            stack.pushMatrix();
            widget1.transform(stack);
        }
        return new LocatedWidget(widget, stack.peek());
    }

    public LocatedWidget(IWidget element, TransformationMatrix transformationMatrix) {
        super(element, transformationMatrix);
    }
}

