/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.network;

import com.cleanroommc.modularui.ModularUI;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    public static final Consumer<PacketBuffer> EMPTY_PACKET = buffer -> {};
    public static final boolean DEDICATED_CLIENT = FMLCommonHandler.instance().getSide().isClient();

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isDedicatedClient() {
        return DEDICATED_CLIENT;
    }

    public static boolean isClient(EntityPlayer player) {
        if (player == null) {
            throw new NullPointerException("Can't get side of null player!");
        }
        return player.field_70170_p == null ? player instanceof EntityPlayerSP : player.field_70170_p.field_72995_K;
    }

    public static void writeByteBuf(PacketBuffer writeTo, ByteBuf writeFrom) {
        writeTo.func_150787_b(writeFrom.readableBytes());
        writeTo.writeBytes(writeFrom);
    }

    public static ByteBuf readByteBuf(PacketBuffer buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
        ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
        directSliceBuffer.release();
        return copiedDataBuffer;
    }

    public static PacketBuffer readPacketBuffer(PacketBuffer buf) {
        return new PacketBuffer(NetworkUtils.readByteBuf(buf));
    }

    public static void writeItemStack(PacketBuffer buffer, ItemStack itemStack) {
        try {
            buffer.func_150788_a(itemStack);
        }
        catch (IOException e) {
            ModularUI.LOGGER.catching((Throwable)e);
        }
    }

    public static ItemStack readItemStack(PacketBuffer buffer) {
        try {
            return buffer.func_150791_c();
        }
        catch (IOException e) {
            ModularUI.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    public static void writeFluidStack(PacketBuffer buffer, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            buffer.writeBoolean(true);
        } else {
            buffer.writeBoolean(false);
            NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
            try {
                buffer.func_150786_a(fluidStackTag);
            }
            catch (IOException e) {
                ModularUI.LOGGER.catching((Throwable)e);
            }
        }
    }

    @Nullable
    public static FluidStack readFluidStack(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            return null;
        }
        try {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
        }
        catch (IOException e) {
            ModularUI.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    public static void writeStringSafe(PacketBuffer buffer, String string) {
        NetworkUtils.writeStringSafe(buffer, string, Short.MAX_VALUE, false);
    }

    public static void writeStringSafe(PacketBuffer buffer, @Nullable String string, boolean crash) {
        NetworkUtils.writeStringSafe(buffer, string, Short.MAX_VALUE, crash);
    }

    public static void writeStringSafe(PacketBuffer buffer, @Nullable String string, int maxBytes) {
        NetworkUtils.writeStringSafe(buffer, string, maxBytes, false);
    }

    public static void writeStringSafe(PacketBuffer buffer, @Nullable String string, int maxBytes, boolean crash) {
        byte[] bytes;
        maxBytes = Math.min(maxBytes, Short.MAX_VALUE);
        if (string == null) {
            buffer.func_150787_b(32768);
            return;
        }
        byte[] bytesTest = string.getBytes(StandardCharsets.UTF_8);
        if (bytesTest.length > maxBytes) {
            if (crash) {
                throw new IllegalArgumentException("Max String size is " + maxBytes + ", but found " + bytesTest.length + " bytes for '" + string + "'!");
            }
            bytes = new byte[maxBytes];
            System.arraycopy(bytesTest, 0, bytes, 0, maxBytes);
            ModularUI.LOGGER.warn("Warning! Synced string exceeds max length!");
        } else {
            bytes = bytesTest;
        }
        buffer.func_150787_b(bytes.length);
        buffer.writeBytes(bytes);
    }

    public static String readStringSafe(PacketBuffer buffer) {
        int length = buffer.func_150792_a();
        if (length > Short.MAX_VALUE) {
            return null;
        }
        String s = buffer.toString(buffer.readerIndex(), length, StandardCharsets.UTF_8);
        buffer.readerIndex(buffer.readerIndex() + length);
        return s;
    }

    public static void writeEnumValue(PacketBuffer buffer, Enum<?> value) {
        buffer.func_150787_b(value.ordinal());
    }

    public static <T extends Enum<T>> T readEnumValue(PacketBuffer buffer, Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[buffer.func_150792_a()];
    }
}

