/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.animation;

import com.cleanroommc.modularui.animation.Animator;
import com.cleanroommc.modularui.animation.IAnimatable;
import java.util.function.Consumer;

public class MutableObjectAnimator<T extends IAnimatable<T>>
extends Animator {
    private final T from;
    private final T to;
    private final T animatable;
    private Consumer<T> intermediateConsumer;

    public MutableObjectAnimator(T animatable, T from, T to) {
        this.from = from;
        this.to = to;
        this.animatable = animatable;
        this.bounds(0.0f, 1.0f);
    }

    @Override
    public void resume(boolean reverse) {
        super.resume(reverse);
        this.animatable.interpolate(this.from, this.to, this.getRawValue());
    }

    @Override
    protected boolean onUpdate() {
        T intermediate = this.animatable.interpolate(this.from, this.to, this.getRawValue());
        if (this.intermediateConsumer != null) {
            this.intermediateConsumer.accept(intermediate);
        }
        return super.onUpdate();
    }

    public MutableObjectAnimator<T> intermediateConsumer(Consumer<T> consumer) {
        this.intermediateConsumer = consumer;
        return this;
    }
}

