/*
 * Decompiled with CFR 0.152.
 */
package makamys.mclib.core;

import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.util.HashMap;
import java.util.Map;
import makamys.mclib.core.MCLib;
import makamys.mclib.core.sharedstate.SharedReference;
import org.apache.commons.lang3.tuple.Triple;

public class TaskQueue {
    static Map<LoaderState, Map<String, Triple<ComparableVersion, Object, Runnable>>> queuedTasks = (Map)SharedReference.get("TaskQueue", "queuedTasks", HashMap.class);

    public static void enqueueTask(LoaderState state, String taskName, Runnable task, ComparableVersion version) {
        Triple<ComparableVersion, Object, Runnable> versionAndTask;
        Map<String, Triple<ComparableVersion, Object, Runnable>> stateTasks = queuedTasks.get(state);
        if (stateTasks == null) {
            stateTasks = new HashMap<String, Triple<ComparableVersion, Object, Runnable>>();
            queuedTasks.put(state, stateTasks);
        }
        if ((versionAndTask = stateTasks.get(taskName)) == null || ((ComparableVersion)versionAndTask.getLeft()).compareTo(version) < 0) {
            stateTasks.put(taskName, (Triple<ComparableVersion, Object, Runnable>)Triple.of((Object)version, (Object)MCLib.instance, (Object)task));
        }
    }

    public static void enqueueTask(LoaderState state, String taskName, Runnable runnable) {
        TaskQueue.enqueueTask(state, taskName, runnable, new ComparableVersion("0.3.7.7"));
    }

    static void consume(LoaderState state, Object owner) {
        Map<String, Triple<ComparableVersion, Object, Runnable>> tasks = queuedTasks.get(state);
        if (tasks != null) {
            tasks.entrySet().removeIf(e -> {
                if (((Triple)e.getValue()).getMiddle() == owner) {
                    ((Runnable)((Triple)e.getValue()).getRight()).run();
                    return true;
                }
                return false;
            });
        }
    }
}

