/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import com.google.common.collect.ImmutableList;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenDeltas
extends WorldGenerator {
    private final int sizeMin = 7;
    private final int sizeMax = 3;
    private final int rimSizeMin = 0;
    private final int rimSizeMax = 2;
    private static final double RIM_SPAWN_CHANCE = 0.9;
    private static final ImmutableList<Block> CAN_REPLACE = ImmutableList.of((Object)ModBlocks.BLACKSTONE.get(), (Object)ModBlocks.BASALT.get());

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        boolean flag = false;
        boolean flag1 = rand.nextDouble() < 0.9;
        int rimXSize = flag1 ? MathHelper.func_76136_a((Random)rand, (int)7, (int)3) : 0;
        int rimZSize = flag1 ? MathHelper.func_76136_a((Random)rand, (int)7, (int)3) : 0;
        boolean flag2 = flag1 && rimXSize != 0 && rimZSize != 0;
        int xSize = MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
        int zSize = MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
        int size = Math.max(xSize, zSize);
        block0: for (int x1 = -xSize; x1 <= xSize; ++x1) {
            for (int z1 = -zSize; z1 <= zSize; ++z1) {
                int xOff = x1 + x;
                int zOff = z1 + z;
                if (Math.abs(xOff - x) + Math.abs(zOff - z) > size + size) continue block0;
                if (Utils.distManhattan(x, y, z, xOff, y, zOff) > size || !WorldGenDeltas.isClear(world, xOff, y, zOff)) continue;
                if (flag2) {
                    flag = true;
                    if (ModBlocks.MAGMA.isEnabled()) {
                        this.func_150516_a(world, xOff, y, zOff, ModBlocks.MAGMA.get(), 0);
                    } else {
                        this.func_150516_a(world, xOff, y, zOff, ModBlocks.BASALT.get(), 0);
                    }
                }
                if (!WorldGenDeltas.isClear(world, xOff + rimXSize, y, zOff + rimZSize)) continue;
                flag = true;
                this.func_150516_a(world, xOff + rimXSize, y, zOff + rimZSize, Blocks.field_150353_l, 0);
            }
        }
        return flag;
    }

    private static boolean isClear(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150353_l) {
            return false;
        }
        if (!CAN_REPLACE.contains((Object)block)) {
            return false;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            boolean flag = world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if ((!flag || dir == ForgeDirection.UP) && (flag || dir != ForgeDirection.UP)) continue;
            return false;
        }
        return true;
    }
}

