/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.tileentities;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.blocks.BlockBeeHive;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.entities.EntityBee;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityBeeHive
extends TileEntity {
    private final List<Bee> bees = Lists.newArrayList();
    private BlockPos flowerPos = null;
    private int honeyLevel = 0;
    private static final Set<RegistryMapping<Block>> TEMPORARY_FIRES_LIST = Sets.newHashSet();

    public TileEntityBeeHive() {
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.CFB_CAMPFIRE.get());
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.CFB_SOUL_CAMPFIRE.get());
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.CFB_FOXFIRE_CAMPFIRE.get());
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.CFB_SHADOW_CAMPFIRE.get());
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.BAMBOO_CAMPFIRE.get());
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.ECRU_LEAVES_FIRE.get());
        TileEntityBeeHive.addSmokeBlock(ExternalContent.Blocks.THAUMCRAFT_AIRY.get());
    }

    public void func_70296_d() {
        if (this.isNearFire()) {
            this.angerBees(null, State.EMERGENCY);
        }
        super.func_70296_d();
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public boolean isNearFire() {
        if (this.func_145831_w() != null) {
            for (BlockPos blockpos : BlockPos.iterate(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e - 1, this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 1)) {
                if (blockpos.getBlock(this.func_145831_w()).func_149688_o() != Material.field_151581_o) continue;
                return true;
            }
        }
        return false;
    }

    public int maxHiveSize() {
        return 3;
    }

    public boolean hasNoBees() {
        return this.bees.isEmpty();
    }

    public boolean isFullOfBees() {
        return this.getBeeCount() == this.maxHiveSize();
    }

    public void angerBees(EntityPlayer p_226963_1_, State p_226963_3_) {
        List<Entity> list = this.tryReleaseBees(p_226963_3_);
        if (p_226963_1_ != null) {
            for (Entity entity : list) {
                EntityBee beeentity;
                if (!(entity instanceof EntityBee) || !((beeentity = (EntityBee)entity).func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) <= 16.0)) continue;
                if (!this.isSmoked()) {
                    beeentity.setBeeAttacker((Entity)p_226963_1_);
                    continue;
                }
                beeentity.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<Entity> tryReleaseBees(State p_226965_2_) {
        ArrayList list = Lists.newArrayList();
        this.bees.removeIf(p_226966_4_ -> this.releaseBee(((Bee)p_226966_4_).entityData, list, p_226965_2_));
        return list;
    }

    public void tryEnterHive(Entity p_226961_1_, boolean p_226961_2_) {
        this.tryEnterHive(p_226961_1_, p_226961_2_, 0);
    }

    public int getBeeCount() {
        return this.bees.size();
    }

    public int getHoneyLevel() {
        return this.honeyLevel;
    }

    public boolean isSmoked() {
        return TileEntityBeeHive.isLitCampfireBelow(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, 5);
    }

    public static boolean isLitCampfireBelow(World world, int x, int y, int z, int spacing) {
        Block block;
        for (int i = 1; i <= spacing && !(block = world.func_147439_a(x, y - i, z)).func_149662_c(); ++i) {
            int meta = world.func_72805_g(x, y - i, z);
            if ((!TEMPORARY_FIRES_LIST.isEmpty() || block.func_149688_o() != Material.field_151581_o) && !TEMPORARY_FIRES_LIST.contains(RegistryMapping.getKeyFor(block, meta))) continue;
            return true;
        }
        return false;
    }

    public static void addSmokeBlock(Block block) {
        TileEntityBeeHive.addSmokeBlock(block, Short.MAX_VALUE);
    }

    public static void addSmokeBlock(Block block, int meta) {
        if (ModRecipes.validateItems(block)) {
            TEMPORARY_FIRES_LIST.add(new RegistryMapping<Block>(block, meta));
        }
    }

    public void tryEnterHive(Entity p_226962_1_, boolean p_226962_2_, int p_226962_3_) {
        if (this.getBeeCount() < this.maxHiveSize() && p_226962_1_ instanceof EntityBee) {
            p_226962_1_.field_70153_n = null;
            Entity living = ((EntityBee)p_226962_1_).func_110166_bE();
            ((EntityBee)p_226962_1_).func_110160_i(true, !(living instanceof EntityPlayer) || !((EntityPlayer)living).field_71075_bZ.field_75098_d);
            NBTTagCompound compoundnbt = new NBTTagCompound();
            p_226962_1_.func_70109_d(compoundnbt);
            compoundnbt.func_82580_o("Riding");
            compoundnbt.func_74778_a("id", (String)EntityList.field_75626_c.get(p_226962_1_.getClass()));
            this.bees.add(new Bee(compoundnbt, p_226962_3_, p_226962_2_ ? 2400 : 600));
            if (this.func_145831_w() != null) {
                EntityBee beeentity = (EntityBee)p_226962_1_;
                if (beeentity.hasFlower() && (!this.hasFlowerPos() || this.func_145831_w().field_73012_v.nextBoolean())) {
                    this.flowerPos = beeentity.getFlowerPos();
                }
                beeentity.field_70173_aa = 0;
                if (beeentity.field_70175_ag) {
                    this.func_145831_w().func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "minecraft_1.21:block.beehive.enter", 1.0f, 1.0f);
                }
            }
            p_226962_1_.func_70106_y();
        }
    }

    private boolean releaseBee(NBTTagCompound p_226967_2_, List<Entity> p_226967_3_, State p_226967_4_) {
        if (this.func_145831_w().func_72935_r() && !this.func_145831_w().func_72896_J() || p_226967_4_ == State.EMERGENCY) {
            boolean flag;
            EnumFacing direction = EnumFacing.func_82600_a((int)(this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) % 6));
            Block front = this.func_145831_w().func_147439_a(this.field_145851_c + direction.func_82601_c(), this.field_145848_d, this.field_145849_e + direction.func_82599_e());
            boolean bl = flag = front.func_149662_c() || front.func_149688_o().func_76224_d();
            if (flag && p_226967_4_ != State.EMERGENCY) {
                return false;
            }
            Entity entity = EntityList.func_75615_a((NBTTagCompound)p_226967_2_, (World)this.func_145831_w());
            if (entity instanceof EntityBee) {
                float f = entity.field_70130_N;
                double d0 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d1 = (double)this.field_145851_c + 0.5 + d0 * (double)direction.func_82601_c();
                double d2 = (double)this.field_145848_d + 0.5 - (double)(entity.field_70131_O / 2.0f);
                double d3 = (double)this.field_145849_e + 0.5 + d0 * (double)direction.func_82599_e();
                entity.func_70012_b(d1, d2, d3, entity.field_70177_z, entity.field_70125_A);
                EntityBee beeentity = (EntityBee)entity;
                if (this.hasFlowerPos() && !beeentity.hasFlower() && this.func_145831_w().field_73012_v.nextFloat() < 0.9f) {
                    beeentity.setFlowerPos(this.flowerPos);
                }
                if (p_226967_4_ == State.HONEY_DELIVERED) {
                    int i;
                    beeentity.onHoneyDelivered();
                    if (this.func_145831_w().func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockBeeHive && (i = this.getHoneyLevel()) < 5) {
                        int j;
                        int n = j = this.func_145831_w().field_73012_v.nextInt(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        this.setHoneyLevel(i + j);
                        BlockBeeHive.updateHiveState(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getHoneyLevel() == 5);
                    }
                }
                beeentity.resetTicksWithoutNectar();
                if (p_226967_3_ != null) {
                    p_226967_3_.add((Entity)beeentity);
                }
                this.func_145831_w().func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "minecraft_1.21:block.beehive.exit", 1.0f, 1.0f);
                this.func_145831_w().func_72838_d((Entity)beeentity);
            }
            return true;
        }
        return false;
    }

    private boolean hasFlowerPos() {
        return this.flowerPos != null;
    }

    private void tickBees() {
        if (this.isNearFire()) {
            this.angerBees(null, State.EMERGENCY);
        }
        Iterator<Bee> iterator = this.bees.iterator();
        while (iterator.hasNext()) {
            Bee beehivetileentity$bee = iterator.next();
            if (beehivetileentity$bee.ticksInHive > beehivetileentity$bee.minOccupationTicks) {
                NBTTagCompound compoundnbt;
                State beehivetileentity$state = (compoundnbt = beehivetileentity$bee.entityData).func_74767_n("HasNectar") ? State.HONEY_DELIVERED : State.BEE_RELEASED;
                if (!this.releaseBee(compoundnbt, null, beehivetileentity$state)) continue;
                iterator.remove();
                continue;
            }
            beehivetileentity$bee.ticksInHive++;
        }
    }

    public void func_145845_h() {
        if (!this.func_145831_w().field_72995_K) {
            this.tickBees();
            if (this.getBeeCount() > 0 && this.func_145831_w().field_73012_v.nextDouble() < 0.005) {
                this.func_145831_w().func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "minecraft_1.21:block.beehive.work", 1.0f, 1.0f);
            }
        }
        super.func_145845_h();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.bees.clear();
        NBTTagList listnbt = compound.func_150295_c("Bees", 10);
        for (int i = 0; i < listnbt.func_74745_c(); ++i) {
            NBTTagCompound compoundnbt = listnbt.func_150305_b(i);
            Bee beehivetileentity$bee = new Bee(compoundnbt.func_74775_l("EntityData"), compoundnbt.func_74762_e("TicksInHive"), compoundnbt.func_74762_e("MinOccupationTicks"));
            this.bees.add(beehivetileentity$bee);
        }
        this.flowerPos = null;
        if (compound.func_74764_b("FlowerPos")) {
            this.flowerPos = BlockPos.readFromNBT(compound.func_74775_l("FlowerPos"));
        }
        if (compound.func_74764_b("honeyLevel")) {
            this.setHoneyLevel(MathHelper.func_76125_a((int)compound.func_74762_e("honeyLevel"), (int)0, (int)5));
        }
        super.func_145839_a(compound);
    }

    public void func_145841_b(NBTTagCompound compound) {
        compound.func_74782_a("Bees", (NBTBase)this.getBees());
        if (this.hasFlowerPos()) {
            compound.func_74782_a("FlowerPos", (NBTBase)BlockPos.writeToNBT(this.flowerPos));
        }
        if (this.getHoneyLevel() > 0) {
            compound.func_74768_a("honeyLevel", this.honeyLevel);
        }
        super.func_145841_b(compound);
    }

    public void destroyAllBees() {
        this.bees.clear();
    }

    public NBTTagList getBees() {
        NBTTagList listnbt = new NBTTagList();
        for (Bee beehivetileentity$bee : this.bees) {
            TileEntityBeeHive.removeUniqueId(beehivetileentity$bee.entityData, "UUID");
            NBTTagCompound compoundnbt = new NBTTagCompound();
            compoundnbt.func_74782_a("EntityData", (NBTBase)beehivetileentity$bee.entityData);
            compoundnbt.func_74768_a("TicksInHive", beehivetileentity$bee.ticksInHive);
            compoundnbt.func_74768_a("MinOccupationTicks", beehivetileentity$bee.minOccupationTicks);
            listnbt.func_74742_a((NBTBase)compoundnbt);
        }
        return listnbt;
    }

    private static void removeUniqueId(NBTTagCompound nbt, String key) {
        nbt.func_82580_o(key + "Most");
        nbt.func_82580_o(key + "Least");
    }

    public void setHoneyLevel(int level) {
        this.honeyLevel = MathHelper.func_76125_a((int)level, (int)0, (int)5);
    }

    public static enum State {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    static class Bee {
        private final NBTTagCompound entityData;
        private int ticksInHive;
        private final int minOccupationTicks;

        private Bee(NBTTagCompound nbt, int ticksinhive, int minoccupationticks) {
            TileEntityBeeHive.removeUniqueId(nbt, "UUID");
            this.entityData = nbt;
            this.ticksInHive = ticksinhive;
            this.minOccupationTicks = minoccupationticks;
        }
    }
}

