/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities.ai;

import ganymedes01.etfuturum.entities.ai.TargetPredicate;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.Vec3;

public class EntityAICustomAvoidEntity
extends EntityAIBase {
    protected final EntityCreature mob;
    private final double slowSpeed;
    private final double fastSpeed;
    protected Entity targetEntity;
    protected final float fleeDistance;
    protected PathEntity fleePath;
    protected final PathNavigate fleeingEntityNavigation;
    protected final Class<? extends Entity> classToFleeFrom;
    protected final Predicate<EntityLivingBase> extraInclusionSelector;
    protected final Predicate<EntityLivingBase> inclusionSelector;
    private final TargetPredicate withinRangePredicate;

    public EntityAICustomAvoidEntity(EntityCreature mob, Class<? extends Entity> fleeFromType, Predicate<EntityLivingBase> extraInclusionSelector, float distance, double slowSpeed, double fastSpeed, Predicate<EntityLivingBase> inclusionSelector, boolean includeHidden) {
        this.mob = mob;
        this.classToFleeFrom = fleeFromType;
        this.extraInclusionSelector = extraInclusionSelector;
        this.fleeDistance = distance;
        this.slowSpeed = slowSpeed;
        this.fastSpeed = fastSpeed;
        this.inclusionSelector = inclusionSelector;
        this.fleeingEntityNavigation = mob.func_70661_as();
        this.func_75248_a(1);
        this.withinRangePredicate = new TargetPredicate().setBaseMaxDistance(distance).setPredicate(inclusionSelector.and(extraInclusionSelector));
        if (includeHidden) {
            this.withinRangePredicate.includeHidden();
        }
    }

    public EntityAICustomAvoidEntity(EntityCreature fleeingEntity, Class<? extends Entity> classToFleeFrom, float fleeDistance, double fleeSlowSpeed, double fleeFastSpeed, Predicate<EntityLivingBase> inclusionSelector, boolean includeHidden) {
        this(fleeingEntity, classToFleeFrom, livingEntity -> true, fleeDistance, fleeSlowSpeed, fleeFastSpeed, inclusionSelector, includeHidden);
    }

    public EntityAICustomAvoidEntity(EntityCreature fleeingEntity, Class<? extends Entity> classToFleeFrom, float fleeDistance, double fleeSlowSpeed, double fleeFastSpeed, Predicate<EntityLivingBase> inclusionSelector) {
        this(fleeingEntity, classToFleeFrom, fleeDistance, fleeSlowSpeed, fleeFastSpeed, inclusionSelector, false);
    }

    public boolean func_75250_a() {
        this.targetEntity = EntityAICustomAvoidEntity.getClosestEntity(this.mob.field_70170_p.func_82733_a(this.classToFleeFrom, this.mob.field_70121_D.func_72314_b((double)this.fleeDistance, 3.0, (double)this.fleeDistance), Entity::func_70089_S), this.withinRangePredicate, (EntityLiving)this.mob, this.mob.field_70165_t, this.mob.field_70163_u, this.mob.field_70161_v);
        if (this.targetEntity == null) {
            return false;
        }
        Vec3 vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.mob, (int)16, (int)7, (Vec3)Vec3.func_72443_a((double)this.targetEntity.field_70165_t, (double)this.targetEntity.field_70163_u, (double)this.targetEntity.field_70161_v));
        if (vec3d == null) {
            return false;
        }
        if (this.targetEntity.func_70092_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) < this.targetEntity.func_70068_e((Entity)this.mob)) {
            return false;
        }
        this.fleePath = this.fleeingEntityNavigation.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        return this.fleePath != null;
    }

    private static Entity getClosestEntity(List<? extends Entity> entityList, TargetPredicate targetPredicate, EntityLiving entity, double x, double y, double z) {
        double d = -1.0;
        Entity livingEntity = null;
        Iterator<? extends Entity> var13 = entityList.iterator();
        while (var13.hasNext()) {
            Entity livingEntity2 = var13.next();
            if (!(livingEntity2 instanceof EntityLivingBase) || !targetPredicate.test(entity, (EntityLivingBase)livingEntity2)) continue;
            double e = livingEntity2.func_70092_e(x, y, z);
            if (d != -1.0 && e >= d) continue;
            d = e;
            livingEntity = livingEntity2;
        }
        return livingEntity;
    }

    public boolean func_75253_b() {
        return !this.fleeingEntityNavigation.func_75500_f();
    }

    public void func_75249_e() {
        this.fleeingEntityNavigation.func_75484_a(this.fleePath, this.slowSpeed);
    }

    public void func_75251_c() {
        this.targetEntity = null;
    }

    public void func_75246_d() {
        if (this.mob.func_70068_e(this.targetEntity) < 49.0) {
            this.mob.func_70661_as().func_75489_a(this.fastSpeed);
        } else {
            this.mob.func_70661_as().func_75489_a(this.slowSpeed);
        }
    }
}

