/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.BeePlantRegistry;
import ganymedes01.etfuturum.api.event.PostTreeGenerateEvent;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.proxy.CommonProxy;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.core.utils.WeightedRandomList;
import ganymedes01.etfuturum.entities.EntityBee;
import ganymedes01.etfuturum.tileentities.TileEntityBeeHive;
import ganymedes01.etfuturum.world.structure.MapGenMesaMineshaft;
import ganymedes01.etfuturum.world.structure.StructureMesaMineshaftPieces;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import org.apache.commons.lang3.ArrayUtils;

public class WorldEventHandler {
    public static final WorldEventHandler INSTANCE = new WorldEventHandler();
    private static boolean hasRegistered;
    private final Map<BiomeGenBase, Float> BEE_NEST_BIOMES = Maps.newHashMap();
    private final Map<RegistryMapping<Block>, WeightedRandomList<WorldGenerator>> BEE_NEST_SAPLINGS = Maps.newHashMap();
    private static final ForgeDirection[] VALID_HIVE_DIRS;

    private WorldEventHandler() {
        WeightedRandomList<Object> oakSaplingTrees = new WeightedRandomList<Object>();
        oakSaplingTrees.addEntry(new WorldGenTrees(false), 0.9);
        oakSaplingTrees.addEntry(new WorldGenBigTree(false), 0.1);
        this.BEE_NEST_SAPLINGS.put(new RegistryMapping<Block>(Blocks.field_150345_g, 0), oakSaplingTrees);
        WeightedRandomList<WorldGenForest> birchSaplingTrees = new WeightedRandomList<WorldGenForest>();
        birchSaplingTrees.addEntry(new WorldGenForest(true, false), 0.0);
        this.BEE_NEST_SAPLINGS.put(new RegistryMapping<Block>(Blocks.field_150345_g, 2), birchSaplingTrees);
        if (ModsList.NATURA.isLoaded()) {
            try {
                WeightedRandomList<WorldGenerator> sakuraSaplingTrees = new WeightedRandomList<WorldGenerator>();
                Constructor constructor = ReflectionHelper.getClass((ClassLoader)CommonProxy.class.getClassLoader(), (String[])new String[]{"mods.natura.worldgen.SakuraTreeGen"}).getConstructor(Boolean.TYPE, Integer.TYPE, Integer.TYPE);
                sakuraSaplingTrees.addEntry((WorldGenerator)constructor.newInstance(true, 1, 0), 0.0);
                this.BEE_NEST_SAPLINGS.put(new RegistryMapping<Block>(GameRegistry.findBlock((String)"Natura", (String)"florasapling"), 3), sakuraSaplingTrees);
                WeightedRandomList<WorldGenerator> mapleSaplingTrees = new WeightedRandomList<WorldGenerator>();
                constructor = ReflectionHelper.getClass((ClassLoader)CommonProxy.class.getClassLoader(), (String[])new String[]{"mods.natura.worldgen.RareTreeGen"}).getConstructor(Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                mapleSaplingTrees.addEntry((WorldGenerator)constructor.newInstance(true, 4, 2, 0, 0), 0.0);
                this.BEE_NEST_SAPLINGS.put(new RegistryMapping<Block>(GameRegistry.findBlock((String)"Natura", (String)"Rare Sapling"), 0), mapleSaplingTrees);
                WeightedRandomList<WorldGenerator> willowSaplingTrees = new WeightedRandomList<WorldGenerator>();
                constructor = ReflectionHelper.getClass((ClassLoader)CommonProxy.class.getClassLoader(), (String[])new String[]{"mods.natura.worldgen.WillowGen"}).getConstructor(Boolean.TYPE);
                willowSaplingTrees.addEntry((WorldGenerator)constructor.newInstance(true), 0.0);
                this.BEE_NEST_SAPLINGS.put(new RegistryMapping<Block>(GameRegistry.findBlock((String)"Natura", (String)"Rare Sapling"), 4), willowSaplingTrees);
            }
            catch (Exception e) {
                Logger.error("Could not add Natura saplings to the beehive grow list!");
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        for (BiomeGenBase biome : Utils.excludeBiomesFromTypesWithDefaults(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST), BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SANDY)) {
            this.BEE_NEST_BIOMES.put(biome, Float.valueOf(0.002f));
        }
        for (BiomeGenBase biome : Utils.excludeBiomesFromTypesWithDefaults(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS), BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SANDY)) {
            this.BEE_NEST_BIOMES.put(biome, Float.valueOf(0.05f));
        }
        this.BEE_NEST_BIOMES.put(BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76767_f.field_76756_M + 128)), Float.valueOf(0.02f));
    }

    @SubscribeEvent
    public void terrainRegisterOverride(InitMapGenEvent event) {
        if (ConfigWorld.enableMesaMineshaft && event.type == InitMapGenEvent.EventType.MINESHAFT) {
            if (!hasRegistered) {
                StructureMesaMineshaftPieces.registerStructurePieces();
                hasRegistered = true;
            }
            event.newGen = new MapGenMesaMineshaft();
        }
    }

    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        int saplingMeta;
        Block sapling;
        WeightedRandomList<WorldGenerator> treesForSapling;
        if (ModBlocks.BEE_NEST.isEnabled() && event.rand.nextFloat() <= 0.05f && this.isFlowerNearby(event.world, event.x, event.y, event.z) && (treesForSapling = this.BEE_NEST_SAPLINGS.get(RegistryMapping.getKeyFor(sapling = event.world.func_147439_a(event.x, event.y, event.z), (saplingMeta = event.world.func_72805_g(event.x, event.y, event.z)) % 8))) != null) {
            event.world.func_147468_f(event.x, event.y, event.z);
            if (treesForSapling.getRandom(event.rand).func_76484_a(event.world, event.rand, event.x, event.y, event.z)) {
                event.setResult(Event.Result.DENY);
                WorldEventHandler.tryPlaceBeeNest(event.world, event.x, event.y, event.z, event.rand, 1);
            } else {
                event.world.func_147465_d(event.x, event.y, event.z, sapling, saplingMeta, 4);
            }
        }
    }

    private boolean isFlowerNearby(World world, int x, int y, int z) {
        for (int x1 = -2; x1 <= 2; ++x1) {
            for (int z1 = -2; z1 <= 2; ++z1) {
                int meta;
                Block block;
                if (z1 == 0 && x1 == 0 || !BeePlantRegistry.isFlower(block = world.func_147439_a(x + x1, y, z + z1), meta = world.func_72805_g(x + x1, y, z + z1))) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onTreeGenerated(PostTreeGenerateEvent event) {
        BiomeGenBase biome;
        if (ModBlocks.BEE_NEST.isEnabled() && event.world.field_73011_w instanceof WorldProviderSurface && this.BEE_NEST_BIOMES.containsKey(biome = event.world.func_72807_a(event.x, event.z)) && event.rand.nextFloat() <= this.BEE_NEST_BIOMES.get(biome).floatValue()) {
            WorldEventHandler.tryPlaceBeeNest(event.world, event.x, event.y, event.z, event.rand, 3);
        }
    }

    public static void tryPlaceBeeNest(World world, int x, int y, int z, Random rand, int minBees) {
        Block targetLog = world.func_147439_a(x, y, z);
        int targetLogMeta = world.func_72805_g(x, y, z);
        ForgeDirection hiveDir = Utils.getRandom(VALID_HIVE_DIRS, rand);
        if (targetLog.isWood((IBlockAccess)world, x, y, z)) {
            int hiveX = x + hiveDir.offsetX;
            int hiveZ = z + hiveDir.offsetZ;
            if (world.func_147439_a(hiveX, y, hiveZ) == targetLog && world.func_72805_g(hiveX, y, hiveZ) == targetLogMeta) {
                x += hiveDir.offsetX;
                z += hiveDir.offsetZ;
            }
            while (y < world.func_72800_K() - 2) {
                if (world.func_147439_a(x, y, z) == targetLog && world.func_72805_g(x, y, z) == targetLogMeta) {
                    Block hiveHangingBlock = world.func_147439_a(hiveX, y + 1, hiveZ);
                    if (hiveHangingBlock.isLeaves((IBlockAccess)world, x, y + 1, z) || hiveHangingBlock == targetLog && world.func_72805_g(hiveX, y + 1, hiveZ) == targetLogMeta) {
                        if (world.func_147439_a(hiveX, y, hiveZ).func_149688_o() == Material.field_151579_a && world.func_147439_a(hiveX, y, hiveZ + 1).func_149688_o() == Material.field_151579_a) {
                            world.func_147465_d(hiveX, y, hiveZ, ModBlocks.BEE_NEST.get(), ForgeDirection.SOUTH.ordinal(), 2);
                            TileEntityBeeHive hive = (TileEntityBeeHive)world.func_147438_o(hiveX, y, hiveZ);
                            for (int i = MathHelper.func_76136_a((Random)rand, (int)minBees, (int)hive.maxHiveSize()) - minBees; i < hive.maxHiveSize(); ++i) {
                                EntityBee bee = new EntityBee(world);
                                hive.tryEnterHive((Entity)bee, false, rand.nextInt(599));
                            }
                            return;
                        }
                        return;
                    }
                } else {
                    return;
                }
                ++y;
            }
        } else {
            int i = 0;
            while (y + i < world.func_72800_K() - 2) {
                if (world.func_147439_a(x, y + i, z).isWood((IBlockAccess)world, x, y + i, z)) {
                    WorldEventHandler.tryPlaceBeeNest(world, x, y + i, z, rand, minBees);
                    return;
                }
                ++i;
            }
        }
    }

    static {
        VALID_HIVE_DIRS = (ForgeDirection[])ArrayUtils.removeElements((Object[])Utils.FORGE_DIRECTIONS, (Object[])new ForgeDirection[]{ForgeDirection.NORTH});
    }
}

