/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.cthandlers;

import ganymedes01.etfuturum.compat.CompatCraftTweaker;
import ganymedes01.etfuturum.recipes.SmithingTableRecipes;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.etfuturum.smithingTable")
public class CTSmithingTable {
    @ZenMethod
    public static void remove(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Removal output cannot be null");
        }
        List<SmithingTableRecipes.SmithingTableRecipe> recipes = SmithingTableRecipes.getInstance().getRecipes();
        ArrayList<SmithingTableRecipes.SmithingTableRecipe> toRemove = new ArrayList<SmithingTableRecipes.SmithingTableRecipe>();
        for (SmithingTableRecipes.SmithingTableRecipe recipe : recipes) {
            if (!output.matches((IItemStack)new MCItemStack(recipe.func_77571_b()))) continue;
            toRemove.add(recipe);
        }
        if (toRemove.isEmpty()) {
            MineTweakerAPI.logWarning((String)("No smithing table recipes for " + output));
        } else {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(toRemove));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient toolSlot, IIngredient ingredient) {
        CTSmithingTable.addRecipe(output, ingredient, toolSlot, true);
    }

    @ZenMethod
    public static void addRecipeNoNBT(IItemStack output, IIngredient toolSlot, IIngredient ingredient) {
        CTSmithingTable.addRecipe(output, ingredient, toolSlot, false);
    }

    private static void addRecipe(IItemStack output, IIngredient ingredientSlot, IIngredient toolSlot, boolean copyNBT) {
        Object toolSlotItem = CompatCraftTweaker.getInternal(toolSlot);
        Object ingredientSlotItem = CompatCraftTweaker.getInternal(ingredientSlot);
        if (toolSlotItem == null || ingredientSlotItem == null || output == null) {
            MineTweakerAPI.logError((String)"One or more smithing table ingredients were invalid or null");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(toolSlotItem, ingredientSlotItem, output, copyNBT));
        }
    }

    private static class RemoveAction
    implements IUndoableAction {
        List<SmithingTableRecipes.SmithingTableRecipe> recipes;

        public RemoveAction(List<SmithingTableRecipes.SmithingTableRecipe> recipes) {
            this.recipes = recipes;
        }

        public void apply() {
            SmithingTableRecipes.getInstance().getRecipes().removeAll(this.recipes);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SmithingTableRecipes.getInstance().getRecipes().addAll(this.recipes);
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " smithing table recipes";
        }

        public String describeUndo() {
            return "Restoring " + this.recipes.size() + " smithing table recipes";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final SmithingTableRecipes.SmithingTableRecipe recipe;
        private final IItemStack output;

        public AddRecipeAction(Object toolSlot, Object ingredientSlot, IItemStack output, boolean copyNBT) {
            this.recipe = new SmithingTableRecipes.SmithingTableRecipe(toolSlot, ingredientSlot, CompatCraftTweaker.getItemStack(output), copyNBT);
            this.output = output;
        }

        public void apply() {
            SmithingTableRecipes.getInstance().addRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            SmithingTableRecipes.getInstance().getRecipes().remove(this.recipe);
        }

        public String describe() {
            return "Adding smithing table recipe for " + this.output;
        }

        public String describeUndo() {
            return "Removing smithing table recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

