/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.gui;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldSettings;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiGamemodeSwitcher
extends GuiScreen {
    private static final ResourceLocation TEXTURE = Utils.getResource("textures/gui/container/gamemode_switcher.png");
    private static final int BUTTON_SIZE = 26;
    private final WorldSettings.GameType currentGameMode;
    private WorldSettings.GameType gameMode = null;
    private int lastMouseX;
    private int lastMouseY;
    private boolean mouseUsedForSelection;
    private final List<GuiGamemodeButton> gameModeButtons = Lists.newArrayList();
    private static WorldSettings.GameType previousGameType;

    public GuiGamemodeSwitcher() {
        this.currentGameMode = this.getPreviousGameMode();
    }

    private static WorldSettings.GameType nextGameType(WorldSettings.GameType type) {
        switch (type) {
            case CREATIVE: {
                return WorldSettings.GameType.SURVIVAL;
            }
            case SURVIVAL: {
                return WorldSettings.GameType.ADVENTURE;
            }
            case ADVENTURE: {
                if (ConfigMixins.enableSpectatorMode) {
                    return SpectatorMode.SPECTATOR_GAMETYPE;
                }
                return WorldSettings.GameType.CREATIVE;
            }
        }
        return WorldSettings.GameType.CREATIVE;
    }

    private WorldSettings.GameType getPreviousGameMode() {
        if (previousGameType == null) {
            previousGameType = Minecraft.func_71410_x().field_71442_b.field_78779_k == WorldSettings.GameType.CREATIVE ? WorldSettings.GameType.SURVIVAL : WorldSettings.GameType.CREATIVE;
        }
        return previousGameType;
    }

    protected void func_73869_a(char typedChar, int keycode) {
        if (keycode == 62) {
            this.mouseUsedForSelection = false;
            this.gameMode = GuiGamemodeSwitcher.nextGameType(this.gameMode);
            return;
        }
        super.func_73869_a(typedChar, keycode);
    }

    public void func_146269_k() {
        super.func_146269_k();
        this.checkForClose();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.gameMode = this.currentGameMode;
        LinkedHashMap<WorldSettings.GameType, ItemStack> map = new LinkedHashMap<WorldSettings.GameType, ItemStack>();
        map.put(WorldSettings.GameType.CREATIVE, new ItemStack((Block)Blocks.field_150349_c));
        map.put(WorldSettings.GameType.SURVIVAL, new ItemStack(Items.field_151040_l));
        map.put(WorldSettings.GameType.ADVENTURE, new ItemStack((Item)Items.field_151148_bJ));
        if (ConfigMixins.enableSpectatorMode) {
            map.put(SpectatorMode.SPECTATOR_GAMETYPE, new ItemStack(Items.field_151061_bv));
        }
        int i = 0;
        int totalWidth = map.size() * 31 - 5;
        for (Map.Entry entry : map.entrySet()) {
            this.gameModeButtons.add(new GuiGamemodeButton((ItemStack)entry.getValue(), (WorldSettings.GameType)entry.getKey(), this.field_146294_l / 2 - totalWidth / 2 + i * 31, this.field_146295_m / 2 - 31));
            ++i;
        }
    }

    private static String getSelectNextText() {
        ChatComponentTranslation f4 = new ChatComponentTranslation("debug.gamemodes.press_f4", new Object[0]);
        f4.func_150256_b().func_150238_a(EnumChatFormatting.AQUA);
        return new ChatComponentTranslation("debug.gamemodes.select_next", new Object[]{f4}).func_150254_d();
    }

    private void apply() {
        if (this.field_146297_k.field_71442_b == null || this.field_146297_k.field_71439_g == null || this.gameMode == null) {
            return;
        }
        if (this.gameMode != this.field_146297_k.field_71442_b.field_78779_k) {
            previousGameType = this.field_146297_k.field_71442_b.field_78779_k;
            this.field_146297_k.field_71439_g.func_71165_d("/gamemode " + this.gameMode.func_77148_a());
        }
    }

    private boolean checkForClose() {
        if (!Keyboard.isKeyDown((int)61)) {
            this.apply();
            this.field_146297_k.func_147108_a(null);
            return true;
        }
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = this.field_146294_l / 2 - 62;
        int j = this.field_146295_m / 2 - 31 - 27;
        GuiGamemodeSwitcher.func_146110_a((int)i, (int)j, (float)0.0f, (float)0.0f, (int)125, (int)75, (float)128.0f, (float)128.0f);
        super.func_73863_a(mouseX, mouseY, delta);
        if (this.gameMode != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)("gameMode." + this.gameMode.func_77149_b()), (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 31 - 20, -1);
        }
        this.func_73732_a(this.field_146297_k.field_71466_p, GuiGamemodeSwitcher.getSelectNextText(), this.field_146294_l / 2, this.field_146295_m / 2 + 5, 0xFFFFFF);
        if (!this.mouseUsedForSelection) {
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.mouseUsedForSelection = true;
        }
        boolean mouseDidNotMove = this.lastMouseX == mouseX && this.lastMouseY == mouseY;
        RenderHelper.func_74520_c();
        for (GuiGamemodeButton buttonWidget : this.gameModeButtons) {
            buttonWidget.render();
            if (this.gameMode != null) {
                buttonWidget.setSelected(this.gameMode == buttonWidget.type);
            }
            if (mouseDidNotMove || mouseX < buttonWidget.x || mouseY < buttonWidget.y || mouseX >= buttonWidget.x + 26 || mouseY >= buttonWidget.y + 26) continue;
            this.gameMode = buttonWidget.type;
        }
        RenderHelper.func_74519_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    class GuiGamemodeButton
    extends Gui {
        private final ItemStack icon;
        private final WorldSettings.GameType type;
        private final int x;
        private final int y;
        private boolean isSelected = false;

        GuiGamemodeButton(ItemStack icon, WorldSettings.GameType type, int x, int y) {
            this.icon = icon;
            this.type = type;
            this.x = x;
            this.y = y;
        }

        void setSelected(boolean b) {
            this.isSelected = b;
        }

        void render() {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)32826);
            GuiGamemodeSwitcher.this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
            GuiGamemodeButton.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)75.0f, (int)26, (int)26, (float)128.0f, (float)128.0f);
            if (this.isSelected) {
                GuiGamemodeButton.func_146110_a((int)this.x, (int)this.y, (float)26.0f, (float)75.0f, (int)26, (int)26, (float)128.0f, (float)128.0f);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
            field_146296_j.func_82406_b(GuiGamemodeSwitcher.this.field_146297_k.field_71466_p, GuiGamemodeSwitcher.this.field_146297_k.func_110434_K(), this.icon, this.x + 5, this.y + 5);
        }
    }
}

