/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public abstract class BuiltInResourcePack
extends AbstractResourcePack {
    private static final Splitter entryNameSplitter = Splitter.on((char)'/').omitEmptyStrings().limit(5);
    private final String modid;
    private final String id;
    protected boolean resourcesEnabled = true;
    protected boolean langEnabled = true;

    public static BuiltInResourcePack register(String id) {
        BuiltInResourcePack rp = BuiltInResourcePack.of(Loader.instance().activeModContainer().getSource(), Loader.instance().activeModContainer().getModId(), id);
        if (rp.isAllEnabled()) {
            BuiltInResourcePack.inject((IResourcePack)rp);
        }
        return rp;
    }

    private static BuiltInResourcePack of(File file, String modid, String id) {
        if (file.isDirectory()) {
            return new BuiltInFolderResourcePack(file, modid, id);
        }
        return new BuiltInFileResourcePack(file, modid, id);
    }

    public BuiltInResourcePack(File file, String modid, String id) {
        super(file);
        this.modid = modid;
        this.id = id;
    }

    public String func_130077_b() {
        return this.modid + "/" + this.id;
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    protected String getRootPath() {
        return "resourcepacks/" + this.id + "/";
    }

    protected void addNamespaceIfLowerCase(Set<String> set, String ns) {
        if (!ns.equals(ns.toLowerCase())) {
            this.func_110594_c(ns);
        } else {
            set.add(ns);
        }
    }

    public BuiltInResourcePack setResourcesEnabled() {
        this.resourcesEnabled = ConfigFunctions.enableNewTextures;
        this.langEnabled = ConfigFunctions.enableLangReplacements;
        return this;
    }

    private boolean isAllEnabled() {
        return this.resourcesEnabled && this.langEnabled;
    }

    private static void inject(IResourcePack resourcePack) {
        List defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
        defaultResourcePacks.add(resourcePack);
        IResourceManager resMan = Minecraft.func_71410_x().func_110442_L();
        if (resMan instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resMan).func_110545_a(resourcePack);
        }
    }

    private static class BuiltInFolderResourcePack
    extends BuiltInResourcePack {
        public BuiltInFolderResourcePack(File file, String modid, String id) {
            super(file, modid, id);
        }

        public Set<String> func_110587_b() {
            HashSet<String> domains = new HashSet<String>();
            File assetsDir = new File(this.field_110597_b, this.getRootPath() + "assets/");
            if (assetsDir.isDirectory()) {
                File[] files;
                for (File file : files = assetsDir.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                    this.addNamespaceIfLowerCase(domains, file.getName());
                }
            }
            return domains;
        }

        protected InputStream func_110591_a(String name) throws IOException {
            if (name.endsWith("lang")) {
                String currentLine;
                ArrayList langFile = Lists.newArrayList();
                File file = new File(this.field_110597_b, this.getRootPath() + "/" + name);
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((currentLine = reader.readLine()) != null) {
                    if (currentLine.startsWith("#") || currentLine.length() == 0) continue;
                    langFile.add(currentLine.trim());
                }
                reader.close();
                ArrayList ignoredKeys = Lists.newArrayList();
                if (!ConfigBlocksItems.enableDyedBeds) {
                    ignoredKeys.add("item.bed.name");
                    ignoredKeys.add("tile.bed.name");
                }
                if (!ConfigBlocksItems.enableVanillaSigns) {
                    ignoredKeys.add("item.sign.name");
                    ignoredKeys.add("tile.sign.name");
                }
                if (!ConfigBlocksItems.enableVanillaDoors) {
                    ignoredKeys.add("item.doorWood.name");
                    ignoredKeys.add("tile.doorWood.name");
                }
                if (!ConfigBlocksItems.enableVanillaTrapdoors) {
                    ignoredKeys.add("tile.trapdoor.name");
                }
                if (!ConfigBlocksItems.enableVanillaFences) {
                    ignoredKeys.add("tile.fence.name");
                    ignoredKeys.add("tile.fenceGate.name");
                }
                ListIterator iterator = langFile.listIterator();
                while (iterator.hasNext()) {
                    String translation = (String)iterator.next();
                    for (String removalCheck : ignoredKeys) {
                        if (!translation.startsWith(removalCheck)) continue;
                        iterator.remove();
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                for (String line : langFile) {
                    baos.write((line + "\n").getBytes());
                }
                byte[] bytes = baos.toByteArray();
                return new ByteArrayInputStream(bytes);
            }
            return new BufferedInputStream(Files.newInputStream(new File(this.field_110597_b, this.getRootPath() + "/" + name).toPath(), new OpenOption[0]));
        }

        protected boolean func_110593_b(String name) {
            if (!this.langEnabled && name.endsWith("lang")) {
                return false;
            }
            return this.resourcesEnabled && new File(this.field_110597_b, this.getRootPath() + "/" + name).isFile();
        }
    }

    private static class BuiltInFileResourcePack
    extends BuiltInResourcePack {
        private final ZipFile zipFile;

        public BuiltInFileResourcePack(File file, String modid, String id) {
            super(file, modid, id);
            try {
                this.zipFile = new ZipFile(file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Set<String> func_110587_b() {
            HashSet<String> domains = new HashSet<String>();
            Enumeration<? extends ZipEntry> en = this.zipFile.entries();
            while (en.hasMoreElements()) {
                ArrayList nameParts;
                ZipEntry entry = en.nextElement();
                if (!entry.getName().startsWith(this.getRootPath() + "assets/") || (nameParts = Lists.newArrayList((Iterable)entryNameSplitter.split((CharSequence)entry.getName()))).size() <= 3) continue;
                this.addNamespaceIfLowerCase(domains, (String)nameParts.get(3));
            }
            return domains;
        }

        protected InputStream func_110591_a(String name) throws IOException {
            return this.zipFile.getInputStream(this.zipFile.getEntry(this.getRootPath() + name));
        }

        protected boolean func_110593_b(String name) {
            return this.resourcesEnabled && this.zipFile.getEntry(this.getRootPath() + name) != null;
        }
    }
}

