/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.api.HoeRegistry;
import ganymedes01.etfuturum.blocks.BaseBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTarget
extends BaseBlock {
    private IIcon topIcon;

    public BlockTarget() {
        super(Material.field_151577_b);
        this.setNames("target");
        this.func_149672_a(field_149779_h);
        this.func_149711_c(0.5f);
        this.func_149752_b(0.5f);
        HoeRegistry.addToHoeArray(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "_side");
        this.topIcon = reg.func_94245_a(this.func_149641_N() + "_top");
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : this.field_149761_L;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (world.field_72995_K) {
            return;
        }
        int power = world.func_72805_g(x, y, z);
        if (power == 0 && e instanceof IProjectile) {
            int newMeta = BlockTarget.determinePower(world, x, y, z, e);
            world.func_72921_c(x, y, z, newMeta, 3);
            int delay = e instanceof EntityArrow ? 20 : 8;
            world.func_147464_a(x, y, z, (Block)this, delay);
        }
    }

    private static double fractionalPos(double n) {
        return n - (double)MathHelper.func_76128_c((double)n);
    }

    private static int determinePower(World world, int x, int y, int z, Entity e) {
        MovingObjectPosition hit = world.func_147447_a(Vec3.func_72443_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v), Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5)), true, false, false);
        if (hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            double d;
            double xDiff = Math.abs(BlockTarget.fractionalPos(hit.field_72307_f.field_72450_a) - 0.5);
            double yDiff = Math.abs(BlockTarget.fractionalPos(hit.field_72307_f.field_72448_b) - 0.5);
            double zDiff = Math.abs(BlockTarget.fractionalPos(hit.field_72307_f.field_72449_c) - 0.5);
            switch (hit.field_72310_e) {
                case 2: 
                case 3: {
                    d = Math.max(xDiff, yDiff);
                    break;
                }
                case 4: 
                case 5: {
                    d = Math.max(yDiff, zDiff);
                    break;
                }
                default: {
                    d = Math.max(xDiff, zDiff);
                }
            }
            double finalDiff = d;
            return Math.max(1, MathHelper.func_76143_f((double)(15.0 * MathHelper.func_151237_a((double)((0.5 - finalDiff) / 0.5), (double)0.0, (double)1.0))));
        }
        return 0;
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random random) {
        worldIn.func_72921_c(x, y, z, 0, 3);
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int meta) {
        return this.func_149709_b(world, x, y, z, meta);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int meta) {
        return world.func_72805_g(x, y, z);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean func_149721_r() {
        return true;
    }
}

