/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.client.particle.CustomParticles;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.entities.EntityBee;
import ganymedes01.etfuturum.tileentities.TileEntityBeeHive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBeeHive
extends BlockContainer {
    protected IIcon bottomIcon;
    protected IIcon topIcon;
    protected IIcon frontIcon;
    protected IIcon frontIconHoney;
    protected boolean isNest;

    public BlockBeeHive() {
        super(Material.field_151575_d);
        this.func_149647_a(EtFuturum.creativeTabBlocks);
        this.func_149672_a(Block.field_149766_f);
    }

    public BlockBeeHive setHiveType(String type, boolean efrprefix) {
        this.func_149663_c(efrprefix ? Utils.getUnlocalisedName(type) : type);
        this.func_149658_d(type);
        if (type.contains("nest")) {
            this.func_149752_b(0.3f);
            this.func_149711_c(0.3f);
            this.isNest = true;
        } else {
            this.func_149752_b(0.6f);
            this.func_149711_c(0.6f);
        }
        return this;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int ordinal = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (ordinal) {
            case 0: {
                ordinal = 2;
                break;
            }
            case 1: {
                ordinal = 5;
                break;
            }
            case 2: {
                ordinal = 3;
                break;
            }
            case 3: {
                ordinal = 4;
            }
        }
        world.func_72921_c(x, y, z, ordinal, 2);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            NBTTagCompound compound = stack.func_77978_p().func_74775_l("BlockEntityTag");
            if (compound.func_74764_b("honeyLevel") && compound.func_74762_e("honeyLevel") == 5) {
                BlockBeeHive.updateHiveState(world, x, y, z, true);
            }
            TileEntity te = world.func_147438_o(x, y, z);
            te.func_145839_a(compound);
            te.field_145851_c = x;
            te.field_145848_d = y;
            te.field_145849_e = z;
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityBeeHive te = (TileEntityBeeHive)world.func_147438_o(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (meta > 6 && te.getHoneyLevel() != 5) {
            te.setHoneyLevel(5);
        }
        BlockBeeHive.updateHiveState(world, x, y, z, te.getHoneyLevel() == 5);
        super.func_149726_b(world, x, y, z);
    }

    public static void updateHiveState(World world, int x, int y, int z, boolean full) {
        if (world.func_72938_d((int)x, (int)z).field_76636_d) {
            int meta = world.func_72805_g(x, y, z);
            if (full && meta < 6) {
                world.func_72921_c(x, y, z, MathHelper.func_76125_a((int)(meta + 6), (int)8, (int)11), 2);
            } else if (!full && meta > 5) {
                world.func_72921_c(x, y, z, MathHelper.func_76125_a((int)(meta - 6), (int)2, (int)5), 2);
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBeeHive();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBeeHive) {
            return ((TileEntityBeeHive)tile).getHoneyLevel();
        }
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.bottomIcon;
            }
            case 1: {
                return this.topIcon;
            }
        }
        return side == meta % 6 || side == 3 && meta == 0 ? (meta > 5 ? this.frontIconHoney : this.frontIcon) : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "_side");
        this.frontIcon = reg.func_94245_a(this.func_149641_N() + "_front");
        this.frontIconHoney = reg.func_94245_a(this.func_149641_N() + "_front_honey");
        if (this.func_149641_N().contains("nest")) {
            this.topIcon = reg.func_94245_a(this.func_149641_N() + "_top");
            this.bottomIcon = reg.func_94245_a(this.func_149641_N() + "_bottom");
        } else {
            this.topIcon = this.bottomIcon = reg.func_94245_a(this.func_149641_N() + "_end");
        }
    }

    private void angerNearbyBees(World p_226881_1_, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(8.0, 6.0, 8.0);
        List list = p_226881_1_.func_72872_a(EntityBee.class, box);
        if (!list.isEmpty()) {
            List list1 = p_226881_1_.func_72872_a(EntityPlayer.class, box);
            int i = list1.size();
            for (EntityBee beeentity : list) {
                if (beeentity.func_70638_az() != null) continue;
                beeentity.setBeeAttacker((Entity)list1.get(p_226881_1_.field_73012_v.nextInt(i)));
            }
        }
    }

    private void dropHoneyComb(World worldIn, int x, int y, int z) {
        this.func_149642_a(worldIn, x, y, z, ModItems.HONEYCOMB.newItemStack(3));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        ItemStack itemstack = player.func_70694_bm();
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityBeeHive)) {
            return false;
        }
        boolean flag = false;
        if (world.func_72805_g(x, y, z) > 6 && itemstack != null) {
            if (itemstack.func_77973_b() instanceof ItemShears) {
                world.func_72956_a((Entity)player, "minecraft_1.21:block.beehive.shear", 1.0f, 1.0f);
                this.dropHoneyComb(world, x, y, z);
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                flag = true;
            } else if (itemstack.func_77973_b() == Items.field_151069_bo) {
                --itemstack.field_77994_a;
                world.func_72956_a((Entity)player, "minecraft_1.21:item.bottle.fill", 1.0f, 1.0f);
                ItemStack bottle = ModItems.HONEY_BOTTLE.newItemStack();
                if (itemstack.field_77994_a == 0) {
                    player.func_70062_b(0, bottle);
                } else if (!player.field_71071_by.func_70441_a(bottle)) {
                    player.func_70099_a(bottle, 0.0f);
                }
                flag = true;
            }
        }
        if (flag) {
            if (!TileEntityBeeHive.isLitCampfireBelow(world, x, y, z, 5)) {
                if (this.hasBees((TileEntityBeeHive)te)) {
                    this.angerNearbyBees(world, x, y, z);
                }
                this.takeHoney((TileEntityBeeHive)te, player, TileEntityBeeHive.State.EMERGENCY);
            } else {
                this.takeHoney((TileEntityBeeHive)te);
            }
            BlockBeeHive.updateHiveState(world, x, y, z, false);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, side, subX, subY, subZ);
    }

    private boolean hasBees(TileEntityBeeHive hive) {
        return !hive.hasNoBees();
    }

    public void takeHoney(TileEntityBeeHive hive, EntityPlayer playerIn, TileEntityBeeHive.State stateIn) {
        this.takeHoney(hive);
        hive.angerBees(playerIn, stateIn);
    }

    public void takeHoney(TileEntityBeeHive hive) {
        hive.setHoneyLevel(0);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72805_g(x, y, z) > 5 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                if (!(random.nextFloat() > 0.3f)) continue;
                CustomParticles.spawnDrippingParticleWithSound(world, world.field_73012_v.nextDouble() + (double)x, y, world.field_73012_v.nextDouble() + (double)z, "minecraft_1.21:block.beehive.drip", -7443180);
            }
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        TileEntity tileentity;
        if (!world.field_72995_K && (tileentity = world.func_147438_o(x, y, z)) instanceof TileEntityBeeHive) {
            boolean empty;
            TileEntityBeeHive beehivetileentity = (TileEntityBeeHive)tileentity;
            boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
            int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            boolean bl = empty = beehivetileentity.hasNoBees() && beehivetileentity.getHoneyLevel() == 0;
            if (!empty && player.field_71075_bZ.field_75098_d || silk) {
                ArrayList<ItemStack> itemStacks = this.getDrops(world, x, y, z, meta, fortune);
                ForgeEventFactory.fireBlockHarvesting(itemStacks, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)fortune, (float)1.0f, (boolean)silk, (EntityPlayer)player);
                for (ItemStack stack : itemStacks) {
                    this.func_149642_a(world, x, y, z, stack);
                }
            } else if (!beehivetileentity.hasNoBees()) {
                this.angerNearbyBees(world, x, y, z);
                beehivetileentity.angerBees(player, TileEntityBeeHive.State.EMERGENCY);
            }
            beehivetileentity.destroyAllBees();
        }
        super.func_149681_a(world, x, y, z, meta, player);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBeeHive) {
            ((TileEntityBeeHive)te).angerBees(null, TileEntityBeeHive.State.EMERGENCY);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149636_a(World worldIn, EntityPlayer player, int x, int y, int z, int meta) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{this.createHiveStack(world.func_147438_o(x, y, z))});
    }

    private ItemStack createHiveStack(TileEntity te) {
        ItemStack itemStack = new ItemStack((Block)this);
        if (te instanceof TileEntityBeeHive) {
            boolean hasBees;
            NBTTagCompound compoundnbt = new NBTTagCompound();
            int honeyLevel = ((TileEntityBeeHive)te).getHoneyLevel();
            boolean bl = hasBees = !((TileEntityBeeHive)te).hasNoBees();
            if (hasBees) {
                compoundnbt.func_74782_a("Bees", (NBTBase)((TileEntityBeeHive)te).getBees());
            }
            if (honeyLevel > 0) {
                compoundnbt.func_74768_a("honeyLevel", honeyLevel);
            }
            if (!compoundnbt.field_74784_a.isEmpty()) {
                itemStack.func_77983_a("BlockEntityTag", (NBTBase)compoundnbt);
            }
        }
        return itemStack;
    }

    public void func_149714_e(World world, int x, int y, int z, int meta) {
        EnumFacing facing;
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity instanceof TileEntityBeeHive && world.func_147439_a(x + (facing = EnumFacing.func_82600_a((int)(meta % 6))).func_82601_c(), y, z + facing.func_82599_e()).func_149688_o() == Material.field_151581_o) {
            ((TileEntityBeeHive)tileentity).angerBees(null, TileEntityBeeHive.State.EMERGENCY);
        }
        super.func_149714_e(world, x, y, z, meta);
    }

    public boolean isFlammable(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return true;
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.isNest ? 30 : 5;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return 20;
    }
}

