/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.blocks.BlockBerryBush;
import ganymedes01.etfuturum.blocks.BlockChorusFlower;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;

public class BeePlantRegistry {
    private static final List<RegistryMapping<Block>> BEE_FLOWERS = Lists.newArrayList();
    private static final List<Block> BEE_CROPS = Lists.newArrayList();

    public static void addFlower(Block block, int meta) {
        if (block instanceof BlockDoublePlant && BlockDoublePlant.func_149887_c((int)meta) && meta != Short.MAX_VALUE) {
            throw new IllegalArgumentException("BlockDoublePlant can't have meta using bit 8, it is for the top half. Bees will go to the top half if the bottom meta is valid.");
        }
        if (ModRecipes.validateItems(block)) {
            BEE_FLOWERS.add(new RegistryMapping<Block>(block, meta));
        }
    }

    public static void addCrop(Block block) {
        if (!(block instanceof IGrowable)) {
            throw new IllegalArgumentException("Bee crops must be instance of IGrowable!");
        }
        BEE_CROPS.add(block);
    }

    public static void removeFlower(Block block, int meta) {
        BEE_FLOWERS.remove(RegistryMapping.getKeyFor(block, meta));
    }

    public static void removeCrop(Block block) {
        BEE_CROPS.remove(block);
    }

    public static boolean isFlower(Block block, int meta) {
        return BEE_FLOWERS.contains(RegistryMapping.getKeyFor(block, meta));
    }

    public static boolean isCrop(Block block) {
        return BEE_CROPS.contains(block);
    }

    public static void init() {
        if (ConfigEntities.enableBees) {
            for (Block block : Block.field_149771_c) {
                if (block instanceof BlockFlower || block instanceof BlockChorusFlower) {
                    BeePlantRegistry.addFlower(block, Short.MAX_VALUE);
                }
                if (!(block instanceof BlockCrops) && !(block instanceof BlockStem) && !(block instanceof BlockBerryBush)) continue;
                BeePlantRegistry.addCrop(block);
            }
            BeePlantRegistry.addFlower((Block)Blocks.field_150398_cm, 0);
            BeePlantRegistry.addFlower((Block)Blocks.field_150398_cm, 1);
            BeePlantRegistry.addFlower((Block)Blocks.field_150398_cm, 4);
            BeePlantRegistry.addFlower((Block)Blocks.field_150398_cm, 5);
            BeePlantRegistry.addFlower(ModBlocks.AZALEA.get(), 1);
            BeePlantRegistry.addFlower(ModBlocks.AZALEA.get(), 9);
            BeePlantRegistry.addFlower(ModBlocks.AZALEA_LEAVES.get(), 1);
            BeePlantRegistry.addFlower(ModBlocks.AZALEA_LEAVES.get(), 5);
            BeePlantRegistry.addFlower(ModBlocks.AZALEA_LEAVES.get(), 9);
            BeePlantRegistry.addFlower(ModBlocks.AZALEA_LEAVES.get(), 13);
            BeePlantRegistry.addFlower(ModBlocks.SAPLING.get(), 0);
            BeePlantRegistry.addFlower(ModBlocks.SAPLING.get(), 8);
            BeePlantRegistry.addFlower(ModBlocks.LEAVES.get(), 1);
            BeePlantRegistry.addFlower(ModBlocks.LEAVES.get(), 5);
            BeePlantRegistry.addFlower(ModBlocks.LEAVES.get(), 9);
            BeePlantRegistry.addFlower(ModBlocks.LEAVES.get(), 13);
        }
    }
}

