/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.api.SpawnInfo;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Minecraft
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        if (recipe.entity.getClass() == EntitySlime.class) {
            drops.get((int)0).variableChance = true;
            drops.get((int)0).chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance((double)drops.get((int)0).chance / 100.0), new MinecraftSlime()));
        } else if (recipe.entity.getClass() == EntityMagmaCube.class) {
            drops.get((int)0).variableChance = true;
            drops.get((int)0).chanceModifiers.addAll(Arrays.asList(new IChanceModifier.NormalChance((double)drops.get((int)0).chance / 100.0), new MinecraftMagmaCube()));
        } else if (recipe.entity.getClass() == EntityVillager.class || recipe.entity.getClass() == EntityIronGolem.class) {
            recipe.spawnList.add(new SpawnInfo.SpawnInfoStructure("Village"));
        } else if (k.equals("witherSkeleton")) {
            recipe.spawnList.add(new SpawnInfo.SpawnInfoStructure("Nether Fortress"));
        } else if (recipe.entity.getClass() == EntityDragon.class) {
            recipe.spawnList.add(new SpawnInfo.SpawnInfoEvent("Enter END"));
        }
    }

    private static class MinecraftSlime
    implements IChanceModifier {
        private MinecraftSlime() {
        }

        @Override
        public String getDescription() {
            return Translations.MINECRAFT_SLIME.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (!(victim instanceof EntitySlime)) {
                return 0.0;
            }
            if (((EntitySlime)victim).func_70809_q() == 1) {
                return chance;
            }
            return 0.0;
        }
    }

    private static class MinecraftMagmaCube
    extends MinecraftSlime {
        private MinecraftMagmaCube() {
        }

        @Override
        public String getDescription() {
            return Translations.MINECRAFT_MAGMA_CUBE.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (!(victim instanceof EntityMagmaCube)) {
                return 0.0;
            }
            if (((EntityMagmaCube)victim).func_70809_q() > 1) {
                return chance;
            }
            return 0.0;
        }
    }
}

