/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public enum ChestChangerType {
    IRONGOLD(IronChestType.IRON, IronChestType.GOLD, "ironGoldUpgrade", "Iron to Gold Chest Upgrade", "mmm", "msm", "mmm"),
    GOLDDIAMOND(IronChestType.GOLD, IronChestType.DIAMOND, "goldDiamondUpgrade", "Gold to Diamond Chest Upgrade", "GGG", "msm", "GGG"),
    COPPERSILVER(IronChestType.COPPER, IronChestType.SILVER, "copperSilverUpgrade", "Copper to Silver Chest Upgrade", "mmm", "msm", "mmm"),
    SILVERGOLD(IronChestType.SILVER, IronChestType.GOLD, "silverGoldUpgrade", "Silver to Gold Chest Upgrade", "mGm", "GsG", "mGm"),
    COPPERSTEEL(IronChestType.COPPER, IronChestType.STEEL, "copperSteelUpgrade", "Copper to Steel Chest Upgrade", "mmm", "msm", "mmm"),
    STEELGOLD(IronChestType.STEEL, IronChestType.GOLD, "steelGoldUpgrade", "Steel to Gold Chest Upgrade", "mGm", "GsG", "mGm"),
    COPPERIRON(IronChestType.COPPER, IronChestType.IRON, "copperIronUpgrade", "Copper to Iron Chest Upgrade", "mGm", "GsG", "mGm"),
    DIAMONDCRYSTAL(IronChestType.DIAMOND, IronChestType.CRYSTAL, "diamondCrystalUpgrade", "Diamond to Crystal Chest Upgrade", "GGG", "GOG", "GGG"),
    WOODIRON(IronChestType.WOOD, IronChestType.IRON, "woodIronUpgrade", "Normal chest to Iron Chest Upgrade", "mmm", "msm", "mmm"),
    WOODCOPPER(IronChestType.WOOD, IronChestType.COPPER, "woodCopperUpgrade", "Normal chest to Copper Chest Upgrade", "mmm", "msm", "mmm"),
    DIAMONDOBSIDIAN(IronChestType.DIAMOND, IronChestType.OBSIDIAN, "diamondObsidianUpgrade", "Diamond to Obsidian Chest Upgrade", "mmm", "mGm", "mmm"),
    OBSIDIANNETHERITE(IronChestType.OBSIDIAN, IronChestType.NETHERITE, "obsidianNetheriteUpgrade", "Obsidian to Netherite Chest Upgrade", "OOO", "msm", "OOO"),
    DIAMONDDARKSTEEL(IronChestType.DIAMOND, IronChestType.DARKSTEEL, "diamondDarkSteelUpgrade", "Diamond to Dark Steel Chest Upgrade", "OOO", "msm", "OOO"),
    CRYSTALDARKSTEEL(IronChestType.CRYSTAL, IronChestType.DARKSTEEL, "crystalDarkSteelUpgrade", "Crystal to Dark Steel Chest Upgrade", "OOO", "msm", "OOO"),
    OBSIDIANDARKSTEEL(IronChestType.OBSIDIAN, IronChestType.DARKSTEEL, "obsidianDarkSteelUpgrade", "Obsidian to Dark Steel Chest Upgrade", "OOO", "msm", "OOO"),
    IRONSTEEL(IronChestType.IRON, IronChestType.STEEL, "ironSteelUpgrade", "Iron to Steel Chest Upgrade", "mGm", "GsG", "mGm"),
    IRONSILVER(IronChestType.IRON, IronChestType.SILVER, "ironSilverUpgrade", "Iron to Silver Chest Upgrade", "mGm", "GsG", "mGm");

    private final IronChestType source;
    private final IronChestType target;
    public final String itemName;
    public final String descriptiveName;
    private ItemChestChanger item;
    private final String[] recipe;

    private ChestChangerType(IronChestType source, IronChestType target, String itemName, String descriptiveName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
        this.descriptiveName = descriptiveName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(IronChestType from) {
        return from == this.source;
    }

    public int getTarget() {
        return this.target.ordinal();
    }

    public boolean isAllowed() {
        return this.target.allowUpgradeFrom(this.source);
    }

    public ItemChestChanger buildItem(Configuration cfg) {
        this.item = new ItemChestChanger(this);
        GameRegistry.registerItem((Item)this.item, (String)this.itemName);
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.getMatList()) {
            for (String targetMat : this.target.getMatList()) {
                Object targetMaterial = IronChestType.translateOreName(targetMat);
                Object sourceMaterial = IronChestType.translateOreName(sourceMat);
                IronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems(Configuration cfg) {
        for (ChestChangerType type : ChestChangerType.values()) {
            if (!type.isAllowed() || !type.source.isEnabled() || !type.target.isEnabled()) continue;
            type.buildItem(cfg);
        }
    }

    public static void generateRecipes() {
        if (IronChest.isGTNHLoaded) {
            return;
        }
        for (ChestChangerType item : ChestChangerType.values()) {
            if (!item.isAllowed()) continue;
            item.addRecipes();
        }
    }
}

