/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui.controls;

import com.creativemd.creativecore.client.rendering.RenderHelper2D;
import com.creativemd.creativecore.client.rendering.RenderHelper3D;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import com.creativemd.creativecore.common.gui.premade.SubGuiControl;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.littletiles.client.render.ITilesRenderer;
import com.creativemd.littletiles.client.render.LittleTilesBlockRenderHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import java.util.ArrayList;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiTileViewer
extends GuiControl {
    public ItemStack stack;
    public float scale = 1.0f;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public ForgeDirection viewDirection = ForgeDirection.EAST;
    public boolean visibleAxis = false;
    public RotationUtils.Axis normalAxis = null;
    public RotationUtils.Axis axisDirection = RotationUtils.Axis.Yaxis;
    public int axisX = 0;
    public int axisY = 0;
    public int axisZ = 0;
    public boolean grabbed = false;
    public Vec3 lastPosition;

    public GuiTileViewer(String name, int x, int y, int width, int height, ItemStack stack) {
        super(name, x, y, width, height);
        this.stack = stack;
        this.updateNormalAxis();
    }

    public void updateNormalAxis() {
        ArrayList<CubeObject> cubes = ((ITilesRenderer)this.stack.func_77973_b()).getRenderingCubes(this.stack);
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double minZ = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        double maxZ = -2.147483648E9;
        for (CubeObject cube : cubes) {
            minX = Math.min(minX, cube.minX);
            minY = Math.min(minY, cube.minY);
            minZ = Math.min(minZ, cube.minZ);
            maxX = Math.max(maxX, cube.maxX);
            maxY = Math.max(maxY, cube.maxY);
            maxZ = Math.max(maxZ, cube.maxZ);
        }
        double sizeX = maxX - minX;
        double sizeY = maxY - minZ;
        double sizeZ = maxZ - minZ;
        switch (this.axisDirection) {
            case Xaxis: {
                if (sizeY >= sizeZ) {
                    this.normalAxis = RotationUtils.Axis.Zaxis;
                    break;
                }
                this.normalAxis = RotationUtils.Axis.Yaxis;
                break;
            }
            case Yaxis: {
                if (sizeX >= sizeZ) {
                    this.normalAxis = RotationUtils.Axis.Zaxis;
                    break;
                }
                this.normalAxis = RotationUtils.Axis.Xaxis;
                break;
            }
            case Zaxis: {
                if (sizeX >= sizeY) {
                    this.normalAxis = RotationUtils.Axis.Yaxis;
                    break;
                }
                this.normalAxis = RotationUtils.Axis.Xaxis;
                break;
            }
        }
    }

    public void changeNormalAxis() {
        switch (this.axisDirection) {
            case Xaxis: {
                if (this.normalAxis == RotationUtils.Axis.Zaxis) {
                    this.normalAxis = RotationUtils.Axis.Yaxis;
                    break;
                }
                this.normalAxis = RotationUtils.Axis.Zaxis;
                break;
            }
            case Yaxis: {
                if (this.normalAxis == RotationUtils.Axis.Zaxis) {
                    this.normalAxis = RotationUtils.Axis.Xaxis;
                    break;
                }
                this.normalAxis = RotationUtils.Axis.Zaxis;
                break;
            }
            case Zaxis: {
                if (this.normalAxis == RotationUtils.Axis.Yaxis) {
                    this.normalAxis = RotationUtils.Axis.Xaxis;
                    break;
                }
                this.normalAxis = RotationUtils.Axis.Yaxis;
                break;
            }
        }
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        Vector4d black = new Vector4d(0.0, 0.0, 0.0, 255.0);
        RenderHelper2D.drawGradientRect(0, 0, this.width, this.height, black, black);
        Vector4d color = new Vector4d(255.0, 255.0, 255.0, 255.0);
        RenderHelper2D.drawGradientRect(1, 1, this.width - 1, this.height - 1, color, color);
        ScaledResolution scaledresolution = new ScaledResolution(mc, GuiTileViewer.mc.field_71443_c, GuiTileViewer.mc.field_71440_d);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        int movex = i / 2 - this.parent.width / 2 + this.posX + 1;
        int movey = j / 2 - this.parent.height / 2 + (this.parent.height - (this.height + this.posY)) + 1;
        if (this.parent instanceof SubGuiControl) {
            movey = j / 2 - ((SubGuiControl)this.parent).parent.parent.height / 2 + (((SubGuiControl)this.parent).parent.parent.height - (this.height + this.posY)) + 1;
        }
        int scale = scaledresolution.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(movex *= scale), (int)(movey *= scale), (int)((this.width - 2) * scale), (int)((this.height - 2) * scale));
        GL11.glPushMatrix();
        GL11.glTranslated((double)((float)(this.width / 2) - this.offsetX), (double)((float)(this.height / 2) - this.offsetY), (double)0.0);
        GL11.glScaled((double)4.0, (double)4.0, (double)4.0);
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        GL11.glTranslated((double)(this.offsetX * 2.0f), (double)(this.offsetY * 2.0f), (double)0.0);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        GL11.glDisable((int)3042);
        if (this.viewDirection == ForgeDirection.UP) {
            GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
        } else if (this.viewDirection == ForgeDirection.DOWN) {
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        } else {
            RenderHelper3D.applyDirection(this.viewDirection);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-2.0f, (float)3.0f, (float)-3.0f);
        GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
        GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnable((int)2896);
        ArrayList<CubeObject> cubes = ((ITilesRenderer)this.stack.func_77973_b()).getRenderingCubes(this.stack);
        if (this.visibleAxis) {
            double min = -10.0 / (double)scale;
            double max = -min;
            CubeObject cube = new LittleTileBox(this.axisX, this.axisY, this.axisZ, this.axisX + 1, this.axisY + 1, this.axisZ + 1).getCube();
            cube.block = Blocks.field_150325_L;
            cube.meta = 0;
            switch (this.normalAxis) {
                case Xaxis: {
                    cube.minX = min;
                    cube.maxX = max;
                    break;
                }
                case Yaxis: {
                    cube.minY = min;
                    cube.maxY = max;
                    break;
                }
                case Zaxis: {
                    cube.minZ = min;
                    cube.maxZ = max;
                    break;
                }
            }
            cubes.add(cube);
            cube = new LittleTileBox(this.axisX, this.axisY, this.axisZ, this.axisX + 1, this.axisY + 1, this.axisZ + 1).getCube();
            cube.block = Blocks.field_150325_L;
            cube.meta = 5;
            switch (this.axisDirection) {
                case Xaxis: {
                    cube.minX = min;
                    cube.maxX = max;
                    break;
                }
                case Yaxis: {
                    cube.minY = min;
                    cube.maxY = max;
                    break;
                }
                case Zaxis: {
                    cube.minZ = min;
                    cube.maxZ = max;
                    break;
                }
            }
            cubes.add(cube);
        }
        LittleTilesBlockRenderHelper.renderInventoryCubes(RenderHelper3D.renderBlocks, cubes, Block.func_149634_a((Item)this.stack.func_77973_b()), this.stack.func_77960_j());
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
    }

    @Override
    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        if (scrolled > 0) {
            this.scale = (float)((double)this.scale * ((double)scrolled * 1.5));
        } else if (scrolled < 0) {
            this.scale = (float)((double)this.scale / ((double)scrolled * -1.5));
        }
        return true;
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        this.grabbed = true;
        this.lastPosition = Vec3.func_72443_a((double)posX, (double)posY, (double)0.0);
        return true;
    }

    @Override
    public void mouseMove(int posX, int posY, int button) {
        Vector2d mouse = this.parent.getMousePos();
        if (this.grabbed) {
            Vec3 currentPosition = Vec3.func_72443_a((double)posX, (double)posY, (double)0.0);
            if (this.lastPosition != null) {
                Vec3 move = this.lastPosition.func_72444_a(currentPosition);
                double percent = 0.3;
                this.offsetX = (float)((double)this.offsetX + (double)(1.0f / this.scale) * move.field_72450_a * percent);
                this.offsetY = (float)((double)this.offsetY + (double)(1.0f / this.scale) * move.field_72448_b * percent);
            }
            this.lastPosition = currentPosition;
        }
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbed) {
            this.lastPosition = null;
            this.grabbed = false;
        }
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        if (key == 78) {
            this.scale *= 2.0f;
            return true;
        }
        if (key == 74) {
            this.scale /= 2.0f;
            return true;
        }
        int ammount = 5;
        if (key == 200) {
            this.offsetY += (float)ammount;
            return true;
        }
        if (key == 208) {
            this.offsetY -= (float)ammount;
            return true;
        }
        if (key == 205) {
            this.offsetX -= (float)ammount;
            return true;
        }
        if (key == 203) {
            this.offsetX += (float)ammount;
            return true;
        }
        return false;
    }

    public void updateViewDirection() {
        switch (this.axisDirection) {
            case Xaxis: {
                this.viewDirection = RotationUtils.Axis.Zaxis.getDirection();
                break;
            }
            case Yaxis: {
                this.viewDirection = RotationUtils.Axis.Yaxis.getDirection();
                break;
            }
            case Zaxis: {
                this.viewDirection = RotationUtils.Axis.Xaxis.getDirection();
                break;
            }
        }
    }
}

