/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.block.IBlockAccessFake;
import com.creativemd.creativecore.client.rendering.ExtendedRenderBlocks;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.LittleTiles;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LittleTilesBlockRenderHelper {
    private static final ThreadLocal<ExtendedRenderBlocks> extraRendererThreadLocal = ThreadLocal.withInitial(ExtendedRenderBlocks::new);

    public static void renderCubes(IBlockAccess world, ArrayList<CubeObject> cubes, int x, int y, int z, Block block, RenderBlocks renderer, ForgeDirection direction) {
        ExtendedRenderBlocks extraRenderer = extraRendererThreadLocal.get();
        extraRenderer.updateRenderer(renderer);
        IBlockAccessFake fake = (IBlockAccessFake)extraRenderer.field_147845_a;
        fake.world = renderer.field_147845_a;
        for (int i = 0; i < cubes.size(); ++i) {
            CubeObject cube = cubes.get(i);
            if (cube.block == null || cube.meta == -1) continue;
            extraRenderer.func_147771_a();
            extraRenderer.func_147782_a(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
            extraRenderer.meta = cube.meta;
            fake.overrideMeta = cube.meta;
            extraRenderer.color = cube.color;
            extraRenderer.field_147847_n = true;
            if (LittleTiles.angelicaCompat != null) {
                LittleTiles.angelicaCompat.setShaderMaterialOverride(cube.block, cube.meta);
            }
            extraRenderer.field_152631_f = true;
            extraRenderer.func_147769_a(cube.block, x, y, z);
            extraRenderer.field_152631_f = false;
            if (LittleTiles.angelicaCompat != null) {
                LittleTiles.angelicaCompat.resetShaderMaterialOverride();
            }
            extraRenderer.field_147847_n = false;
            extraRenderer.color = ColorUtils.WHITE;
        }
    }

    public static void renderInventoryCubes(RenderBlocks renderer, ArrayList<CubeObject> cubes, Block parBlock, int meta) {
        Tessellator tesselator = Tessellator.field_78398_a;
        for (int i = 0; i < cubes.size(); ++i) {
            Block block;
            CubeObject cube = cubes.get(i);
            int metadata = 0;
            if (cube.meta != -1) {
                metadata = cube.meta;
            }
            if ((block = parBlock) instanceof BlockAir) {
                block = Blocks.field_150348_b;
            }
            renderer.func_147782_a(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
            if (cube.block != null && !(cube.block instanceof BlockAir)) {
                block = cube.block;
                meta = 0;
            }
            int j = block.func_149741_i(metadata);
            if (cube.color != ColorUtils.WHITE) {
                j = cube.color;
            }
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(j & 0xFF) / 255.0f;
            float brightness = 1.0f;
            GL11.glColor4f((float)(f1 * brightness), (float)(f2 * brightness), (float)(f3 * brightness), (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tesselator.func_78382_b();
            tesselator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, metadata));
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, metadata));
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(2, metadata));
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(3, metadata));
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, metadata));
            tesselator.func_78381_a();
            tesselator.func_78382_b();
            tesselator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, metadata));
            tesselator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }
}

