/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.DefaultProviderV2;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.blay09.mods.craftingtweaks.api.SimpleTweakProvider;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class SimpleTweakProviderImpl
implements SimpleTweakProvider {
    private final RotationHandler smallRotationHandler = new RotationHandler(){

        @Override
        public boolean ignoreSlotId(int slotId) {
            return false;
        }

        @Override
        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 2;
                    }
                }
            } else {
                switch (slotId) {
                    case 1: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                    case 0: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                }
            }
            return 0;
        }
    };
    private final String modid;
    private final DefaultProviderV2 defaultProvider = CraftingTweaksAPI.createDefaultProviderV2();
    private int gridSlotNumber = 1;
    private int gridSize = 9;
    private boolean hideButtons;
    private boolean phantomItems;
    private TweakSettings tweakRotate = new TweakSettings(true, true, -16, 16);
    private TweakSettings tweakBalance = new TweakSettings(true, true, -16, 34);
    private TweakSettings tweakClear = new TweakSettings(true, true, -16, 52);
    private EnumFacing alignToGrid;

    public SimpleTweakProviderImpl(String modid) {
        this.modid = modid;
    }

    @Override
    public void setAlignToGrid(EnumFacing direction) {
        this.alignToGrid = direction;
    }

    @Override
    public void setTweakRotate(boolean enabled, boolean showButton, int x, int y) {
        this.tweakRotate = new TweakSettings(enabled, showButton, x, y);
    }

    @Override
    public void setTweakBalance(boolean enabled, boolean showButton, int x, int y) {
        this.tweakBalance = new TweakSettings(enabled, showButton, x, y);
    }

    @Override
    public void setTweakClear(boolean enabled, boolean showButton, int x, int y) {
        this.tweakClear = new TweakSettings(enabled, showButton, x, y);
    }

    @Override
    public void setPhantomItems(boolean phantomItems) {
        this.phantomItems = phantomItems;
    }

    @Override
    public void setGrid(int slotNumber, int size) {
        this.gridSlotNumber = slotNumber;
        this.gridSize = size;
    }

    @Override
    public void setHideButtons(boolean hideButtons) {
        this.hideButtons = hideButtons;
    }

    @Override
    public String getModId() {
        return this.modid;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public void clearGrid(EntityPlayer entityPlayer, Container container, int id, boolean forced) {
        if (this.tweakClear.enabled) {
            this.defaultProvider.clearGrid(this, id, entityPlayer, container, this.phantomItems, forced);
        }
    }

    @Override
    public void rotateGrid(EntityPlayer entityPlayer, Container container, int id, boolean counterClockwise) {
        if (this.tweakRotate.enabled) {
            this.defaultProvider.rotateGrid(this, id, entityPlayer, container, this.getCraftingGridSize(entityPlayer, container, id) == 4 ? this.smallRotationHandler : this.defaultProvider.getRotationHandler(), counterClockwise);
        }
    }

    @Override
    public void balanceGrid(EntityPlayer entityPlayer, Container container, int id) {
        if (this.tweakBalance.enabled) {
            this.defaultProvider.balanceGrid(this, id, entityPlayer, container);
        }
    }

    @Override
    public void spreadGrid(EntityPlayer entityPlayer, Container container, int id) {
        if (this.tweakBalance.enabled) {
            this.defaultProvider.spreadGrid(this, id, entityPlayer, container);
        }
    }

    @Override
    public boolean canTransferFrom(EntityPlayer entityPlayer, Container container, int id, Slot sourceSlot) {
        return this.defaultProvider.canTransferFrom(entityPlayer, container, sourceSlot);
    }

    @Override
    public boolean transferIntoGrid(EntityPlayer entityPlayer, Container container, int id, Slot sourceSlot) {
        return this.defaultProvider.transferIntoGrid(this, id, entityPlayer, container, sourceSlot);
    }

    @Override
    public ItemStack putIntoGrid(EntityPlayer entityPlayer, Container container, int id, ItemStack itemStack, int index) {
        return this.defaultProvider.putIntoGrid(this, id, entityPlayer, container, itemStack, index);
    }

    @Override
    public IInventory getCraftMatrix(EntityPlayer entityPlayer, Container container, int id) {
        return ((Slot)container.field_75151_b.get((int)this.getCraftingGridStart((EntityPlayer)entityPlayer, (Container)container, (int)id))).field_75224_c;
    }

    @Override
    public boolean requiresServerSide() {
        return this.phantomItems;
    }

    @Override
    public int getCraftingGridStart(EntityPlayer entityPlayer, Container container, int id) {
        return this.gridSlotNumber;
    }

    @Override
    public int getCraftingGridSize(EntityPlayer entityPlayer, Container container, int id) {
        return this.gridSize;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiContainer guiContainer, List<GuiButton> buttonList) {
        if (!this.hideButtons) {
            int buttonY;
            int buttonX;
            int index = 0;
            if (this.tweakRotate.enabled && this.tweakRotate.showButton) {
                buttonX = this.tweakRotate.buttonX;
                buttonY = this.tweakRotate.buttonY;
                if (this.alignToGrid != null) {
                    buttonX = this.getButtonX(guiContainer, index);
                    buttonY = this.getButtonY(guiContainer, index);
                }
                buttonList.add(CraftingTweaksAPI.createRotateButtonRelative(0, guiContainer, buttonX, buttonY));
                ++index;
            }
            if (this.tweakBalance.enabled && this.tweakBalance.showButton) {
                buttonX = this.tweakBalance.buttonX;
                buttonY = this.tweakBalance.buttonY;
                if (this.alignToGrid != null) {
                    buttonX = this.getButtonX(guiContainer, index);
                    buttonY = this.getButtonY(guiContainer, index);
                }
                buttonList.add(CraftingTweaksAPI.createBalanceButtonRelative(0, guiContainer, buttonX, buttonY));
                ++index;
            }
            if (this.tweakClear.enabled && this.tweakClear.showButton) {
                buttonX = this.tweakClear.buttonX;
                buttonY = this.tweakClear.buttonY;
                if (this.alignToGrid != null) {
                    buttonX = this.getButtonX(guiContainer, index);
                    buttonY = this.getButtonY(guiContainer, index);
                }
                buttonList.add(CraftingTweaksAPI.createClearButtonRelative(0, guiContainer, buttonX, buttonY));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getButtonX(GuiContainer guiContainer, int index) {
        Slot firstSlot = (Slot)guiContainer.field_147002_h.field_75151_b.get(this.getCraftingGridStart((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity(), guiContainer.field_147002_h, 0));
        switch (this.alignToGrid) {
            case NORTH: 
            case UP: 
            case SOUTH: 
            case DOWN: {
                return firstSlot.field_75223_e + 18 * index;
            }
            case EAST: {
                return firstSlot.field_75223_e + 54 + 1;
            }
            case WEST: {
                return firstSlot.field_75223_e - 19;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    private int getButtonY(GuiContainer guiContainer, int index) {
        Slot firstSlot = (Slot)guiContainer.field_147002_h.field_75151_b.get(this.getCraftingGridStart((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity(), guiContainer.field_147002_h, 0));
        switch (this.alignToGrid) {
            case NORTH: 
            case UP: {
                return firstSlot.field_75221_f - 18 - 1;
            }
            case SOUTH: 
            case DOWN: {
                return firstSlot.field_75221_f + 54 + 1;
            }
            case EAST: 
            case WEST: {
                return firstSlot.field_75221_f + 18 * index;
            }
        }
        return 0;
    }

    public static class TweakSettings {
        public final boolean enabled;
        public final boolean showButton;
        public final int buttonX;
        public final int buttonY;

        public TweakSettings(boolean enabled, boolean showButton, int buttonX, int buttonY) {
            this.enabled = enabled;
            this.showButton = showButton;
            this.buttonX = buttonX;
            this.buttonY = buttonY;
        }
    }
}

