/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import buildcraft.factory.gui.SlotWorkbench;
import codechicken.lib.inventory.SlotDummy;
import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.common.network.CShortcut;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import com.cleanroommc.bogosorter.compat.Mods;
import com.cleanroommc.bogosorter.mixins.early.minecraft.SlotAccessor;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gui.slots.SlotCraftMatrix;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class ShortcutHandler {
    public static boolean SetCanTakeStack;

    @SideOnly(value=Side.CLIENT)
    public static boolean moveSingleItem(GuiContainer guiContainer, boolean emptySlot) {
        Slot slot = guiContainer.field_147006_u;
        if (slot == null || slot.func_75211_c() == null) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(emptySlot ? CShortcut.Type.MOVE_SINGLE_EMPTY : CShortcut.Type.MOVE_SINGLE, slot.field_75222_d));
        return true;
    }

    public static void moveSingleItem(EntityPlayer player, Container container, SlotAccessor slot, boolean emptySlot) {
        ShortcutHandler.moveItemStack(player, container, slot, emptySlot, 1);
    }

    public static void moveItemStack(EntityPlayer player, Container container, SlotAccessor slot, boolean emptySlot, int amount) {
        if (slot == null || slot.callGetStack() == null) {
            return;
        }
        ItemStack stack = slot.callGetStack();
        Slot currentSlot = container.func_75139_a(slot.getSlotNumber());
        if (currentSlot == null) {
            return;
        }
        if (ShortcutHandler.SlotDummyOrCrafting(currentSlot)) {
            return;
        }
        amount = Math.min(amount, stack.func_77976_d());
        ItemStack toInsert = stack.func_77946_l();
        toInsert.field_77994_a = amount;
        if (BogoSortAPI.isValidSortable(container)) {
            SlotGroup otherSlots;
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            SlotGroup slots = sortingContext.getSlotGroup(slot.getSlotNumber());
            SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
            if (otherSlots == null || slots == otherSlots) {
                return;
            }
            toInsert = emptySlot ? BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert, true) : BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert);
        } else {
            ArrayList<SlotAccessor> otherSlots = new ArrayList<SlotAccessor>();
            boolean isPlayer = BogoSortAPI.isPlayerSlot(slot);
            for (Slot slot1 : container.field_75151_b) {
                if (isPlayer == BogoSortAPI.isPlayerSlot(slot1) || isPlayer == ShortcutHandler.SlotDummyOrCrafting(slot1)) continue;
                otherSlots.add(BogoSortAPI.INSTANCE.getSlot(slot1));
            }
            ItemStack itemStack = toInsert = emptySlot ? BogoSortAPI.insert(container, otherSlots, toInsert, true) : BogoSortAPI.insert(container, otherSlots, toInsert);
        }
        if (toInsert == null) {
            toInsert = stack.func_77946_l();
            toInsert.field_77994_a -= amount;
            if (toInsert.field_77994_a == 0) {
                toInsert = null;
            }
            slot.callPutStack(toInsert);
            slot.callOnSlotChange(stack, toInsert);
            toInsert = stack.func_77946_l();
            toInsert.field_77994_a = amount;
            slot.callOnPickupFromSlot(player, toInsert);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean moveAllItems(GuiContainer guiContainer, boolean sameItemOnly) {
        Container container = guiContainer.field_147002_h;
        Slot slot = guiContainer.field_147006_u;
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return false;
        }
        SlotAccessor slotAccessor = BogoSortAPI.INSTANCE.getSlot(slot);
        if (sameItemOnly && slotAccessor.callGetStack() == null) {
            return false;
        }
        SetCanTakeStack = false;
        NetworkHandler.sendToServer(new CShortcut(sameItemOnly ? CShortcut.Type.MOVE_ALL_SAME : CShortcut.Type.MOVE_ALL, slotAccessor.getSlotNumber()));
        return true;
    }

    public static void moveAllItems(EntityPlayer player, Container container, SlotAccessor slot, boolean sameItemOnly) {
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return;
        }
        Slot currentSlot = container.func_75139_a(slot.getSlotNumber());
        if (currentSlot == null) {
            return;
        }
        if (ShortcutHandler.SlotDummyOrCrafting(currentSlot)) {
            return;
        }
        if (slot.callGetStack() != null) {
            SlotGroup otherSlots;
            ItemStack stack = slot.callGetStack().func_77946_l();
            if (sameItemOnly && stack == null) {
                return;
            }
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            SlotGroup slots = sortingContext.getSlotGroup(slot.getSlotNumber());
            SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
            if (slots == null || otherSlots == null || slots == otherSlots) {
                return;
            }
            for (SlotAccessor slot1 : slots.getSlots()) {
                ItemStack stackInSlot = slot1.callGetStack();
                if (stackInSlot == null || sameItemOnly && !stackInSlot.func_77969_a(stack)) continue;
                ItemStack copy = stackInSlot.func_77946_l();
                ItemStack remainder = BogoSortAPI.insert(container, otherSlots.getSlots(), copy);
                if (remainder == null) {
                    slot1.callPutStack(null);
                    continue;
                }
                int inserted = stackInSlot.field_77994_a - remainder.field_77994_a;
                if (inserted <= 0) continue;
                slot1.callPutStack(remainder.func_77946_l());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean dropItems(GuiContainer guiContainer, boolean onlySameType) {
        Slot slot = guiContainer.field_147006_u;
        if (slot == null || slot.func_75211_c() == null) {
            return false;
        }
        if (!BogoSortAPI.isPlayerSlot(slot) && !BogoSortAPI.isValidSortable(guiContainer.field_147002_h)) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(onlySameType ? CShortcut.Type.DROP_ALL_SAME : CShortcut.Type.DROP_ALL, slot.field_75222_d));
        return true;
    }

    public static void dropItems(EntityPlayer player, Container container, SlotAccessor slot, boolean onlySameType) {
        ItemStack stack = slot.callGetStack();
        if (onlySameType && stack == null) {
            return;
        }
        Slot currentSlot = container.func_75139_a(slot.getSlotNumber());
        if (currentSlot == null) {
            return;
        }
        if (ShortcutHandler.SlotDummyOrCrafting(currentSlot)) {
            return;
        }
        SlotGroup slots = GuiSortingContext.getOrCreate(container).getSlotGroup(slot.getSlotNumber());
        if (slots == null) {
            return;
        }
        for (SlotAccessor slot1 : slots.getSlots()) {
            ItemStack stackInSlot = slot1.callGetStack();
            if (stackInSlot == null || onlySameType && !stackInSlot.func_77969_a(stack)) continue;
            slot1.callPutStack(null);
            player.func_71019_a(stackInSlot, true);
        }
    }

    public static ItemStack insertToSlots(List<SlotAccessor> slots, ItemStack stack, boolean emptyOnly) {
        for (SlotAccessor slot : slots) {
            stack = ShortcutHandler.insert(slot, stack, emptyOnly);
            if (stack != null) continue;
            return stack;
        }
        return stack;
    }

    public static ItemStack insert(SlotAccessor slot, ItemStack stack, boolean emptyOnly) {
        ItemStack stackInSlot = slot.callGetStack();
        if (emptyOnly) {
            if (stackInSlot != null || !slot.callIsItemValid(stack)) {
                return stack;
            }
            int amount = Math.min(stack.field_77994_a, slot.callGetSlotStackLimit());
            if (amount <= 0) {
                return stack;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = amount;
            stack.field_77994_a -= amount;
            slot.callPutStack(newStack);
            return stack.field_77994_a == 0 ? null : stack;
        }
        if (stackInSlot != null && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
            int amount = Math.min(slot.callGetSlotStackLimit(), Math.min(stack.field_77994_a, stack.func_77976_d() - stackInSlot.field_77994_a));
            if (amount <= 0) {
                return stack;
            }
            stack.field_77994_a -= amount;
            stackInSlot.field_77994_a += amount;
            slot.callPutStack(stackInSlot);
            return stack.field_77994_a == 0 ? null : stack;
        }
        return stack;
    }

    public static boolean SlotDummyOrCrafting(Slot slot) {
        if (Mods.CodeChickenCore.isLoaded() && slot instanceof SlotDummy) {
            return true;
        }
        if (Mods.Forestry.isLoaded() && slot instanceof SlotCraftMatrix) {
            return true;
        }
        if (Mods.Buildcraft.isLoaded() && slot instanceof SlotWorkbench) {
            return true;
        }
        return slot instanceof SlotCrafting;
    }
}

