/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import java.util.Locale;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.Metal;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemNugget
extends ItemRailcraft {
    public ItemNugget() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public void initItem() {
        for (EnumNugget n : EnumNugget.VALUES) {
            ItemStack stack = new ItemStack((Item)this, 1, n.ordinal());
            RailcraftRegistry.register(stack);
            ForestryPlugin.addBackpackItem("miner", stack);
            Metal m = Metal.get(n);
            OreDictionary.registerOre((String)m.getNuggetTag(), (ItemStack)m.getNugget());
        }
    }

    @Override
    public String getOreTag(IItemMetaEnum meta) {
        this.assertMeta(meta);
        return ((EnumNugget)meta).oreTag;
    }

    @Override
    public void defineRecipes() {
        for (EnumNugget n : EnumNugget.VALUES) {
            Metal m = Metal.get(n);
            CraftingPlugin.addShapelessRecipe(m.getNugget(9), m.getIngot());
            CraftingPlugin.addShapedRecipe(m.getIngot(), "NNN", "NNN", "NNN", Character.valueOf('N'), m.getNuggetTag());
        }
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        for (EnumNugget nugget : EnumNugget.VALUES) {
            nugget.icon = iconRegister.func_94245_a("railcraft:nugget." + nugget.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (EnumNugget dust : EnumNugget.VALUES) {
            list.add(new ItemStack((Item)this, 1, dust.ordinal()));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= EnumNugget.values().length) {
            return EnumNugget.IRON.icon;
        }
        return EnumNugget.VALUES[damage].icon;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumNugget.VALUES.length) {
            return "";
        }
        switch (EnumNugget.VALUES[damage]) {
            case IRON: {
                return "item.railcraft.nugget.iron";
            }
            case STEEL: {
                return "item.railcraft.nugget.steel";
            }
            case COPPER: {
                return "item.railcraft.nugget.copper";
            }
            case TIN: {
                return "item.railcraft.nugget.tin";
            }
            case LEAD: {
                return "item.railcraft.nugget.lead";
            }
        }
        return "";
    }

    public static enum EnumNugget implements IItemMetaEnum
    {
        IRON("nuggetIron"),
        STEEL("nuggetSteel"),
        COPPER("nuggetCopper"),
        TIN("nuggetTin"),
        LEAD("nuggetLead");

        public static EnumNugget[] VALUES;
        private IIcon icon;
        private String oreTag;

        private EnumNugget(String oreTag) {
            this.oreTag = oreTag;
        }

        @Override
        public Object getAlternate() {
            return this.oreTag;
        }

        @Override
        public Class<? extends ItemRailcraft> getItemClass() {
            return ItemNugget.class;
        }

        static {
            VALUES = EnumNugget.values();
        }
    }
}

