/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.Optional;
import ic2.api.item.IBoxable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.common.blocks.tracks.BlockTrackElevator;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.enchantment.RailcraftEnchantments;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.IBoxable", modid="IC2"), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft|Core")})
public class ItemCrowbar
extends ItemTool
implements IToolCrowbar,
IBoxable,
IToolWrench {
    public static final byte BOOST_DAMAGE = 3;
    private static final String ITEM_TAG = "railcraft.tool.crowbar";
    private static Item item;
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<Class<? extends Block>>();
    private final Set<Class<? extends Block>> bannedRotations = new HashSet<Class<? extends Block>>();

    public static void registerItem() {
        if (item == null && RailcraftConfig.isItemEnabled(ITEM_TAG)) {
            item = new ItemCrowbar(Item.ToolMaterial.IRON);
            item.func_77655_b(ITEM_TAG);
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " RI", "RIR", "IR ", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dyeRed");
            LootPlugin.addLootTool(new ItemStack(item), 1, 1, ITEM_TAG);
            LootPlugin.addLootWorkshop(new ItemStack(item), 1, 1, ITEM_TAG);
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public static Item getItemObj() {
        return item;
    }

    protected ItemCrowbar(Item.ToolMaterial material) {
        super(3.0f, material, new HashSet<Block>(Arrays.asList(Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc)));
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
        this.shiftRotations.add(BlockLever.class);
        this.shiftRotations.add(BlockButton.class);
        this.shiftRotations.add(BlockChest.class);
        this.bannedRotations.add(BlockRailBase.class);
        this.setHarvestLevel("crowbar", 2);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (TrackTools.isRailBlock(block)) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    private boolean isShiftRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> shift : this.shiftRotations) {
            if (!shift.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private boolean isBannedRotation(Class<? extends Block> cls) {
        for (Class<? extends Block> banned : this.bannedRotations) {
            if (!banned.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (player.func_70093_af() != this.isShiftRotation(block.getClass())) {
            return false;
        }
        if (this.isBannedRotation(block.getClass())) {
            return false;
        }
        if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        int level;
        EntityPlayer player;
        if (!world.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_70093_af() && (level = EnchantmentHelper.func_77506_a((int)RailcraftEnchantments.destruction.field_77352_x, (ItemStack)stack) * 2 + 1) > 0) {
            this.checkBlocks(world, level, x, y, z, entity, stack);
        }
        return super.func_150894_a(stack, world, block, x, y, z, entity);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
        player.func_71038_i();
    }

    @Override
    public boolean canWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        return true;
    }

    @Override
    public void onWhack(EntityPlayer player, ItemStack crowbar, int x, int y, int z) {
        crowbar.func_77972_a(1, (EntityLivingBase)player);
        player.func_71038_i();
    }

    @Override
    public boolean canLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return player.func_70093_af();
    }

    @Override
    public void onLink(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.func_77972_a(1, (EntityLivingBase)player);
        player.func_71038_i();
    }

    @Override
    public boolean canBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        return !player.func_70093_af();
    }

    @Override
    public void onBoost(EntityPlayer player, ItemStack crowbar, EntityMinecart cart) {
        crowbar.func_77972_a(3, (EntityLivingBase)player);
        player.func_71038_i();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advInfo) {
        info.add(LocalizationPlugin.translate("item.railcraft.tool.crowbar.tip"));
    }

    private void removeAndDrop(World world, int x, int y, int z, Block block, EntityLivingBase entity, ItemStack stack, int meta) {
        if (!ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)entity).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)entity), (int)x, (int)y, (int)z).isCanceled()) {
            InvTools.dropItems(block.getDrops(world, x, y, z, meta, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack)), world, x, y, z);
            world.func_147468_f(x, y, z);
        }
    }

    private void removeExtraBlocks(World world, int level, int x, int y, int z, Block block, EntityLivingBase entity, ItemStack stack, int meta) {
        if (level > 0) {
            this.removeAndDrop(world, x, y, z, block, entity, stack, meta);
            this.checkBlocks(world, level, x, y, z, entity, stack);
        }
    }

    private void checkBlock(World world, int level, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        int meta = WorldPlugin.getBlockMetadata((IBlockAccess)world, x, y, z);
        if (TrackTools.isRailBlock(block) || block instanceof BlockTrackElevator || block.isToolEffective("crowbar", meta)) {
            this.removeExtraBlocks(world, level - 1, x, y, z, block, entity, stack, meta);
        }
    }

    private void checkBlocks(World world, int level, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        this.checkBlock(world, level, x, y, z - 1, entity, stack);
        this.checkBlock(world, level, x, y + 1, z - 1, entity, stack);
        this.checkBlock(world, level, x, y - 1, z - 1, entity, stack);
        this.checkBlock(world, level, x, y, z + 1, entity, stack);
        this.checkBlock(world, level, x, y + 1, z + 1, entity, stack);
        this.checkBlock(world, level, x, y - 1, z + 1, entity, stack);
        this.checkBlock(world, level, x + 1, y, z, entity, stack);
        this.checkBlock(world, level, x + 1, y + 1, z, entity, stack);
        this.checkBlock(world, level, x + 1, y - 1, z, entity, stack);
        this.checkBlock(world, level, x - 1, y, z, entity, stack);
        this.checkBlock(world, level, x - 1, y + 1, z, entity, stack);
        this.checkBlock(world, level, x - 1, y - 1, z, entity, stack);
        this.checkBlock(world, level, x, y + 1, z, entity, stack);
        this.checkBlock(world, level, x, y - 1, z, entity, stack);
    }
}

