/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.util.misc.Vec2D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;

public class LinkageHandler {
    public static final String LINK_A_TIMER = "linkA_timer";
    public static final String LINK_B_TIMER = "linkB_timer";
    public static final double LINK_DRAG = 0.95;
    public static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.7f;
    private static final float HS_STIFFNESS = 0.7f;
    private static final float DAMPING = 0.4f;
    private static final float HS_DAMPING = 0.3f;
    private static final float FORCE_LIMITER = 6.0f;
    private static final int TICK_HISTORY = 200;
    private static LinkageHandler instance;

    private LinkageHandler() {
    }

    public static LinkageHandler getInstance() {
        if (instance == null) {
            instance = new LinkageHandler();
        }
        return instance;
    }

    private float getOptimalDistance(EntityMinecart cart1, EntityMinecart cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart1).getOptimalDistance(cart2)) : (dist += 0.78f);
        dist = cart2 instanceof ILinkableCart ? (dist += ((ILinkableCart)cart2).getOptimalDistance(cart1)) : (dist += 0.78f);
        return dist;
    }

    private boolean canCartBeAdjustedBy(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == cart2) {
            return false;
        }
        if (cart1 instanceof ILinkableCart && !((ILinkableCart)cart1).canBeAdjusted(cart2)) {
            return false;
        }
        return !RailTools.isCartLockedDown(cart1);
    }

    protected void adjustVelocity(EntityMinecart cart1, EntityMinecart cart2, char link) {
        String timer = LINK_A_TIMER;
        if (link == 'B') {
            timer = LINK_B_TIMER;
        }
        if (cart1.field_70170_p.field_73011_w.field_76574_g != cart2.field_70170_p.field_73011_w.field_76574_g) {
            short count = cart1.getEntityData().func_74765_d(timer);
            if ((count = (short)(count + 1)) > 200) {
                LinkageManager.instance().breakLink(cart1, cart2);
                LinkageManager.printDebug("Reason For Broken Link: Carts in different dimensions.", new Object[0]);
            }
            cart1.getEntityData().func_74777_a(timer, count);
            return;
        }
        cart1.getEntityData().func_74777_a(timer, (short)0);
        double dist = cart1.func_70032_d((Entity)cart2);
        if (dist > 8.0) {
            LinkageManager.instance().breakLink(cart1, cart2);
            LinkageManager.printDebug("Reason For Broken Link: Max distance exceeded.", new Object[0]);
            return;
        }
        boolean adj1 = this.canCartBeAdjustedBy(cart1, cart2);
        boolean adj2 = this.canCartBeAdjustedBy(cart2, cart1);
        Vec2D cart1Pos = new Vec2D(cart1.field_70165_t, cart1.field_70161_v);
        Vec2D cart2Pos = new Vec2D(cart2.field_70165_t, cart2.field_70161_v);
        Vec2D unit = Vec2D.subtract(cart2Pos, cart1Pos);
        unit.normalize();
        float optDist = this.getOptimalDistance(cart1, cart2);
        double stretch = dist - (double)optDist;
        boolean highSpeed = cart1.getEntityData().func_74767_n("HighSpeed");
        double stiffness = highSpeed ? (double)0.7f : (double)0.7f;
        double springX = stiffness * stretch * unit.getX();
        double springZ = stiffness * stretch * unit.getY();
        springX = this.limitForce(springX);
        springZ = this.limitForce(springZ);
        if (adj1) {
            cart1.field_70159_w += springX;
            cart1.field_70179_y += springZ;
        }
        if (adj2) {
            cart2.field_70159_w -= springX;
            cart2.field_70179_y -= springZ;
        }
        Vec2D cart1Vel = new Vec2D(cart1.field_70159_w, cart1.field_70179_y);
        Vec2D cart2Vel = new Vec2D(cart2.field_70159_w, cart2.field_70179_y);
        double dot = Vec2D.subtract(cart2Vel, cart1Vel).dotProduct(unit);
        double damping = highSpeed ? (double)0.3f : (double)0.4f;
        double dampX = damping * dot * unit.getX();
        double dampZ = damping * dot * unit.getY();
        dampX = this.limitForce(dampX);
        dampZ = this.limitForce(dampZ);
        if (adj1) {
            cart1.field_70159_w += dampX;
            cart1.field_70179_y += dampZ;
        }
        if (adj2) {
            cart2.field_70159_w -= dampX;
            cart2.field_70179_y -= dampZ;
        }
    }

    private double limitForce(double force) {
        return Math.copySign(Math.min(Math.abs(force), 6.0), force);
    }

    private void adjustCart(EntityMinecart cart, LinkageManager lm) {
        EntityMinecart link_B;
        int launched = cart.getEntityData().func_74762_e("Launched");
        if (launched > 0) {
            return;
        }
        if (this.isOnElevator(cart)) {
            return;
        }
        boolean linked = false;
        EntityMinecart link_A = lm.getLinkedCartA(cart);
        if (link_A != null) {
            if (!Train.areInSameTrain(cart, link_A)) {
                lm.breakLink(cart, link_A);
                lm.createLink(cart, link_A);
                return;
            }
            launched = link_A.getEntityData().func_74762_e("Launched");
            if (launched <= 0 && !this.isOnElevator(link_A)) {
                linked = true;
                this.adjustVelocity(cart, link_A, 'A');
            }
        }
        if ((link_B = lm.getLinkedCartB(cart)) != null) {
            if (!Train.areInSameTrain(cart, link_B)) {
                lm.breakLink(cart, link_B);
                lm.createLink(cart, link_B);
                return;
            }
            launched = link_B.getEntityData().func_74762_e("Launched");
            if (launched <= 0 && !this.isOnElevator(link_B)) {
                linked = true;
                this.adjustVelocity(cart, link_B, 'B');
            }
        }
        if (linked && ModuleManager.isModuleLoaded(ModuleManager.Module.LOCOMOTIVES)) {
            cart.field_70159_w *= 0.95;
            cart.field_70179_y *= 0.95;
        }
        if (link_A == null && link_B != null || link_A != null && link_B == null) {
            Train.getTrain(cart).refreshMaxSpeed();
        } else if (link_A == null) {
            Train.getTrain(cart).setMaxSpeed(1.2f);
        }
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.minecart;
        LinkageManager lm = LinkageManager.instance();
        if (cart.field_70128_L) {
            lm.removeLinkageId(cart);
            return;
        }
        lm.getLinkageId(cart);
        this.adjustCart(cart, lm);
    }

    @SubscribeEvent
    public void onMinecartInteract(MinecartInteractEvent event) {
        EntityPlayer player = event.player;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IToolCrowbar) {
            event.setCanceled(true);
        }
    }

    private boolean isOnElevator(EntityMinecart cart) {
        byte elevator = cart.getEntityData().func_74771_c("elevator");
        return elevator > 0;
    }

    @SubscribeEvent
    public void canMinecartTick(EntityEvent.CanUpdate event) {
        if (event.entity instanceof EntityMinecart) {
            EntityMinecart cart = (EntityMinecart)event.entity;
            Train train = Train.getTrain(cart);
            for (EntityCartAnchor anchor : train.getCarts(EntityCartAnchor.class)) {
                if (!anchor.hasActiveTicket()) continue;
                event.canUpdate = true;
                return;
            }
        }
    }
}

