/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.hidden;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileHidden
extends RailcraftTileEntity {
    private static final int DURATION_MIINUTES = 15;
    private static final long DURATION_MILLISECONDS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
    public WorldCoordinate lastMarker;
    public long colorSeed;
    public long timestamp = -1L;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            if (this.lastMarker != null && EffectManager.instance.isGoggleAuraActive(ItemGoggles.GoggleAura.TRACKING)) {
                EffectManager.instance.trailEffect(this.lastMarker.x, this.lastMarker.y, this.lastMarker.z, this, this.colorSeed);
            }
            return;
        }
        if (this.timestamp == -1L) {
            return;
        }
        if (this.clock % 64 == 0) {
            boolean timeElapsed;
            if (BlockHidden.getBlock() == null || !RailcraftConfig.isTrackingAuraEnabled()) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            Block block = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (block != BlockHidden.getBlock()) {
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            boolean bl = timeElapsed = System.currentTimeMillis() - this.timestamp >= DURATION_MILLISECONDS;
            if (timeElapsed) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a, 0, 6);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.lastMarker != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("dim", this.lastMarker.dimension);
            nbt.func_74768_a("x", this.lastMarker.x);
            nbt.func_74768_a("y", this.lastMarker.y);
            nbt.func_74768_a("z", this.lastMarker.z);
            data.func_74782_a("last", (NBTBase)nbt);
        }
        data.func_74772_a("seed", this.colorSeed);
        data.func_74772_a("time", this.timestamp);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("last")) {
            NBTTagCompound nbt = data.func_74775_l("last");
            int dim = nbt.func_74762_e("dim");
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            this.lastMarker = new WorldCoordinate(dim, x, y, z);
        }
        this.colorSeed = data.func_74763_f("seed");
        this.timestamp = data.func_74763_f("time");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeLong(this.colorSeed);
        data.writeBoolean(this.lastMarker != null);
        if (this.lastMarker != null) {
            data.writeInt(this.lastMarker.dimension);
            data.writeInt(this.lastMarker.x);
            data.writeInt(this.lastMarker.y);
            data.writeInt(this.lastMarker.z);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.colorSeed = data.readLong();
        if (data.readBoolean()) {
            int dim = data.readInt();
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            this.lastMarker = new WorldCoordinate(dim, x, y, z);
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getLocalizationTag() {
        return "";
    }

    @Override
    public short getId() {
        return 111;
    }
}

